/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import java.util.concurrent.TimeUnit;

public class AnimatedTimeRange
implements Updatable {
    private final Range mRange;
    private boolean mShift;
    private long mOffsetUs;

    public AnimatedTimeRange(Range range, long offsetUs) {
        this.mRange = range;
        this.mOffsetUs = offsetUs;
    }

    public void setShift(boolean shift) {
        this.mShift = shift;
    }

    @Override
    public void update(long elapsedNs) {
        long now = TimeUnit.NANOSECONDS.toMicros(System.nanoTime()) - this.mOffsetUs;
        double min = this.mRange.getMin();
        double max = this.mRange.getMax();
        this.mRange.setMax(now);
        if (this.mShift) {
            this.mRange.setMin(min + ((double)now - max));
        }
    }
}

