/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class SelectInCoverageView
implements SelectInTarget {
    private final Project myProject;

    public SelectInCoverageView(Project project) {
        this.myProject = project;
    }

    public String toString() {
        return CoverageBundle.message("coverage.view.title", new Object[0]);
    }

    public boolean canSelect(SelectInContext context) {
        CoverageView coverageView;
        CoverageSuitesBundle suitesBundle = CoverageDataManager.getInstance(this.myProject).getCurrentSuitesBundle();
        if (suitesBundle != null && (coverageView = CoverageViewManager.getInstance(this.myProject).getToolwindow(suitesBundle)) != null) {
            VirtualFile file = context.getVirtualFile();
            return !file.isDirectory() && coverageView.canSelect(file);
        }
        return false;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        CoverageSuitesBundle suitesBundle = CoverageDataManager.getInstance(this.myProject).getCurrentSuitesBundle();
        if (suitesBundle != null) {
            CoverageViewManager coverageViewManager = CoverageViewManager.getInstance(this.myProject);
            CoverageView coverageView = coverageViewManager.getToolwindow(suitesBundle);
            coverageView.select(context.getVirtualFile());
            coverageViewManager.activateToolwindow(coverageView, requestFocus);
        }
    }

    public String getToolWindowId() {
        return "Coverage";
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 4.5f;
    }
}

