/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.yaml.ConfigYamlAccessor;
import com.intellij.microservices.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.completion.YamlKeyCompletionInsertHandler;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

class SpringBootApplicationYamlKeyCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final Key<String> CONFIG_KEY = Key.create((String)"ymlConfigKey");
    private static final InsertHandler<LookupElementDecorator<LookupElementBuilder>> INSERT_HANDLER = new YamlKeyCompletionInsertHandler<LookupElementDecorator<LookupElementBuilder>>(){

        @NotNull
        protected YAMLKeyValue createNewEntry(@NotNull YAMLDocument document, LookupElementDecorator<LookupElementBuilder> item, @Nullable YAMLKeyValue parent) {
            if (document == null) {
                1.$$$reportNull$$$0(0);
            }
            String qualifiedKey = (String)item.getCopyableUserData(CONFIG_KEY);
            assert (qualifiedKey != null);
            ConfigYamlAccessor accessor = new ConfigYamlAccessor(document, (MetaConfigKeyManager)SpringBootApplicationMetaConfigKeyManager.getInstance());
            YAMLKeyValue keyValue = accessor.findExistingKey(qualifiedKey);
            if (keyValue != null) {
                YAMLKeyValue yAMLKeyValue = keyValue;
                if (yAMLKeyValue == null) {
                    1.$$$reportNull$$$0(1);
                }
                return yAMLKeyValue;
            }
            keyValue = accessor.create(qualifiedKey);
            assert (keyValue != null) : qualifiedKey;
            YAMLKeyValue yAMLKeyValue = keyValue;
            if (yAMLKeyValue == null) {
                1.$$$reportNull$$$0(2);
            }
            return yAMLKeyValue;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElementDecorator<LookupElementBuilder> item) {
            if (context == null) {
                1.$$$reportNull$$$0(3);
            }
            if (item == null) {
                1.$$$reportNull$$$0(4);
            }
            super.handleInsert(context, item);
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyCompletionProvider$1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyCompletionProvider$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewEntry";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    SpringBootApplicationYamlKeyCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        YAMLFile yamlFile;
        Module module;
        if (parameters == null) {
            SpringBootApplicationYamlKeyCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringBootApplicationYamlKeyCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SpringBootApplicationYamlKeyCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(yamlFile = (YAMLFile)parameters.getOriginalFile()))) == null) {
            return;
        }
        SpringBootApplicationMetaConfigKeyManager keyManager = SpringBootApplicationMetaConfigKeyManager.getInstance();
        List configKeys = keyManager.getAllMetaConfigKeys(module);
        MetaConfigKeyManager.ConfigKeyNameBinder binder = keyManager.getConfigKeyNameBinder(module);
        PsiElement element = parameters.getPosition();
        PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)element);
        PsiElement originalDocumentAnchor = originalElement != null ? originalElement : element.getContainingFile().getOriginalFile().findElementAt(parameters.getOffset());
        ConfigYamlAccessor accessor = new ConfigYamlAccessor((PsiElement)ObjectUtils.chooseNotNull((Object)originalDocumentAnchor, (Object)element), (MetaConfigKeyManager)keyManager);
        YAMLKeyValue parentYamlKeyValue = ConfigYamlUtils.getParentKeyValue((PsiElement)element, (PsiElement)originalElement);
        ConfigYamlUtils.addCompletionAddIfNeeded((CompletionParameters)parameters, (CompletionResultSet)result);
        String fullParentConfigName = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)parentYamlKeyValue);
        List currentLineComponents = ConfigYamlUtils.getCurrentLineKeyComponents((PsiElement)((PsiElement)ObjectUtils.chooseNotNull((Object)originalElement, (Object)element)), (MetaConfigKeyManager.ConfigKeyNameBinder)binder, (String)fullParentConfigName, (List)configKeys);
        if (!currentLineComponents.isEmpty()) {
            result.addAllElements((Iterable)currentLineComponents);
        }
        String parentConfigKeyName = parentYamlKeyValue == null || parameters.getInvocationCount() > 1 ? "" : fullParentConfigName;
        ArrayList<LookupElement> keyLookupElements = new ArrayList<LookupElement>();
        for (MetaConfigKey configKey : configKeys) {
            if (!parentConfigKeyName.isEmpty() && !binder.matchesPrefix(configKey, parentConfigKeyName) || accessor.findExistingKey(configKey.getName()) != null) continue;
            LookupElementBuilder builder = configKey.getPresentation().getLookupElement();
            builder.putCopyableUserData(CONFIG_KEY, (Object)configKey.getName());
            LookupElementDecorator insertHandler = LookupElementDecorator.withInsertHandler((LookupElement)builder, INSERT_HANDLER);
            LookupElement lookupElement = configKey.getPresentation().tuneLookupElement((LookupElement)insertHandler);
            keyLookupElements.add(lookupElement);
        }
        result.addAllElements(keyLookupElements);
        if (SpringBootLibraryUtil.isBelowVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_2_0)) {
            SpringBootApplicationYamlKeyCompletionProvider.addSpringProfiles(yamlFile, accessor, result);
        }
        result.stopHere();
    }

    private static void addSpringProfiles(YAMLFile yamlFile, ConfigYamlAccessor accessor, CompletionResultSet result) {
        if (yamlFile.getDocuments().size() > 1 && accessor.findExistingKey("spring.profiles") == null) {
            LookupElementBuilder builder = LookupElementBuilder.create((String)"spring.profiles").withIcon(SpringApiIcons.SpringProfile).withTailText(SpringBootApiBundle.message((String)"application.config.spring.profiles.completion.tail", (Object[])new Object[0]), true);
            builder.putCopyableUserData(CONFIG_KEY, (Object)builder.getLookupString());
            LookupElementDecorator decorator = LookupElementDecorator.withInsertHandler((LookupElement)builder, INSERT_HANDLER);
            result.addElement((LookupElement)decorator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

