/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.microservices.config.MicroservicesConfigBundle;
import com.intellij.microservices.config.MicroservicesConfigUtils;
import com.intellij.microservices.config.yaml.ConfigYamlUtils;
import com.intellij.microservices.config.yaml.ShowDuplicateKeysQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.application.config.SpringBootConfigFileHighlightingUtil;
import com.intellij.spring.boot.application.config.SpringBootReplacementTokenStorage;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlDeprecationFixFactory;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.FormBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public class SpringBootApplicationYamlInspection
extends LocalInspectionTool {
    @NonNls
    public String replacementTokens = "@";
    final SpringBootReplacementTokenStorage myReplacementTokenStorage = new SpringBootReplacementTokenStorage();

    public SpringBootApplicationYamlInspection() {
        this.myReplacementTokenStorage.deserialize(this.replacementTokens);
    }

    public List<Couple<String>> getReplacementTokens() {
        return this.myReplacementTokenStorage.getReplacementTokens();
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            SpringBootApplicationYamlInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringBootApplicationYamlInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof YAMLFile)) {
            return null;
        }
        YAMLFile yamlFile = (YAMLFile)file;
        if (!SpringCommonUtils.hasSpringFacets((Project)manager.getProject()) || !SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile((PsiFile)yamlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (SpringBootLibraryUtil.isBelowVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        final ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        final SpringBootConfigFileHighlightingUtil configFileHighlightingUtil = new SpringBootConfigFileHighlightingUtil(holder);
        List yamlDocuments = yamlFile.getDocuments();
        final boolean hasMultipleDocuments = yamlDocuments.size() > 1;
        for (YAMLDocument document : yamlDocuments) {
            final MultiMap duplicates = new MultiMap();
            document.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitElement(element);
                    if (!(element instanceof YAMLKeyValue)) {
                        return;
                    }
                    YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
                    PsiElement keyElement = yamlKeyValue.getKey();
                    if (keyElement == null) {
                        return;
                    }
                    YAMLValue valueElement = yamlKeyValue.getValue();
                    if (valueElement != null && !(valueElement instanceof YAMLScalar) && !(valueElement instanceof YAMLSequence)) {
                        return;
                    }
                    if (valueElement != null) {
                        if (valueElement instanceof YAMLScalar) {
                            MicroservicesConfigUtils.highlightValueReferences((PsiElement)valueElement, (ProblemsHolder)holder);
                        } else {
                            YAMLSequence sequence = (YAMLSequence)valueElement;
                            for (YAMLSequenceItem item : sequence.getItems()) {
                                YAMLValue itemValue = item.getValue();
                                if (!(itemValue instanceof YAMLScalar)) continue;
                                MicroservicesConfigUtils.highlightValueReferences((PsiElement)itemValue, (ProblemsHolder)holder);
                            }
                        }
                    }
                    if (PsiTreeUtil.getContextOfType((PsiElement)yamlKeyValue, (Class[])new Class[]{YAMLSequenceItem.class}) != null) {
                        return;
                    }
                    MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)yamlKeyValue);
                    if (configKey == null) {
                        String qualifiedConfigKeyName = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue);
                        if (hasMultipleDocuments && "spring.profiles".equals(qualifiedConfigKeyName)) {
                            return;
                        }
                        configFileHighlightingUtil.highlightUnresolvedConfigKey(keyElement, qualifiedConfigKeyName);
                        return;
                    }
                    if (configKey.getDeprecation() != MetaConfigKey.Deprecation.NOT_DEPRECATED) {
                        LocalQuickFix[] fixes = SpringBootApplicationYamlDeprecationFixFactory.getDeprecationFixes(keyElement, configKey, isOnTheFly);
                        configFileHighlightingUtil.highlightDeprecatedConfigKey(keyElement, configKey, fixes);
                    }
                    if (!configKey.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) {
                        duplicates.putValue((Object)configKey.getName(), (Object)yamlKeyValue);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlInspection$1", "visitElement"));
                }
            });
            for (Map.Entry entry : duplicates.entrySet()) {
                Collection values = (Collection)entry.getValue();
                if (values.size() == 1) continue;
                String configKey = (String)entry.getKey();
                ShowDuplicateKeysQuickFix showDuplicatesFix = new ShowDuplicateKeysQuickFix(configKey, values);
                for (YAMLKeyValue keyValue : values) {
                    holder.registerProblem((PsiElement)keyValue, MicroservicesConfigBundle.message((String)"config.duplicate.key", (Object[])new Object[]{configKey}), new LocalQuickFix[]{showDuplicatesFix});
                }
            }
        }
        return holder.getResultsArray();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            SpringBootApplicationYamlInspection.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        this.myReplacementTokenStorage.deserialize(this.replacementTokens);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            SpringBootApplicationYamlInspection.$$$reportNull$$$0(3);
        }
        this.replacementTokens = this.myReplacementTokenStorage.serialize();
        super.writeSettings(element);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm(SpringBootApiBundle.message((String)"spring.boot.replacement.token.column.name", (Object[])new Object[0]), this.myReplacementTokenStorage.getTokens());
        return FormBuilder.createFormBuilder().addComponentFillVertically(form.getContentPanel(), 0).getPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

