/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.IntrospectionError;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public final class Introspection {
    private Introspection() {
    }

    @Nonnull
    public static PropertyDescriptor getProperty(@Nonnull String propertyName, @Nonnull Object target) {
        BeanInfo beanInfo;
        Preconditions.checkNotNullOrEmpty(propertyName);
        Preconditions.checkNotNull(target);
        Class<?> type = target.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(type);
        }
        catch (Throwable t) {
            String msg = String.format("Unable to get BeanInfo for type %s", type.getName());
            throw new IntrospectionError(Preconditions.checkNotNull(msg), t);
        }
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            if (!propertyName.equals(descriptor.getName())) continue;
            return descriptor;
        }
        throw Introspection.propertyNotFoundError(propertyName, target);
    }

    @Nonnull
    private static IntrospectionError propertyNotFoundError(@Nonnull String propertyName, @Nonnull Object target) {
        Method getter = Introspection.findGetter(propertyName, target);
        String format = getter == null ? "No getter for property %s in %s" : (!Modifier.isPublic(getter.getModifiers()) ? "No public getter for property %s in %s" : "Unable to find property %s in %s");
        String msg = String.format(format, Strings.quote(propertyName), target.getClass().getName());
        return new IntrospectionError(Preconditions.checkNotNull(msg));
    }

    private static Method findGetter(@Nonnull String propertyName, @Nonnull Object target) {
        String capitalized = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method getter = Introspection.findMethod("get" + capitalized, target);
        if (getter != null) {
            return getter;
        }
        return Introspection.findMethod("is" + capitalized, target);
    }

    @Nullable
    private static Method findMethod(@Nonnull String name, @Nonnull Object target) {
        try {
            return target.getClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

