/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Lists;
import org.fest.util.Sets;
import org.fest.util.ToString;

public final class Collections {
    private Collections() {
    }

    @Nonnull
    public static <T> Collection<T> duplicatesFrom(@Nullable Collection<T> c) {
        LinkedHashSet<T> duplicates = new LinkedHashSet<T>();
        if (c == null) {
            return duplicates;
        }
        HashSet unique = Sets.newHashSet();
        for (T e : c) {
            if (unique.contains(e)) {
                duplicates.add(e);
                continue;
            }
            unique.add(e);
        }
        return duplicates;
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> c) {
        return c == null || c.isEmpty();
    }

    @Nullable
    public static String format(@Nullable Collection<?> c) {
        if (c == null) {
            return null;
        }
        Iterator<?> i = c.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        while (true) {
            Object e;
            b.append((e = i.next()) == c ? "(this Collection)" : ToString.toStringOf(e));
            if (!i.hasNext()) {
                return b.append(']').toString();
            }
            b.append(", ");
        }
    }

    @Nonnull
    public static <T> List<T> nonNullElementsIn(@Nullable Collection<T> c) {
        if (c == null) {
            return Lists.emptyList();
        }
        ArrayList<T> nonNull = new ArrayList<T>();
        for (T element : c) {
            if (element == null) continue;
            nonNull.add(element);
        }
        return nonNull;
    }
}

