/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointType;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001c0\u001b\u001a\f\u0010\u001d\u001a\u00020\u0018*\u00020\u001eH\u0000\u00a8\u0006\u001f"}, d2={"computeLineBreakpointVariants", "", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "project", "Lcom/intellij/openapi/project/Project;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "kotlinBreakpointType", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;", "getLambdasAtLineIfAny", "Lorg/jetbrains/kotlin/psi/KtFunction;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "getTopmostParentOnLineOrSelf", "Lcom/intellij/psi/PsiElement;", "element", "document", "Lcom/intellij/openapi/editor/Document;", "isBreakpointApplicable", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "checker", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/ApplicabilityResult;", "isInlineOnly", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "kotlin.jvm-debugger.core"})
public final class BreakpointTypeUtilsKt {
    public static final boolean isBreakpointApplicable(@NotNull VirtualFile file, int line, @NotNull Project project, @NotNull Function1<? super PsiElement, ApplicabilityResult> checker) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(checker, (String)"checker");
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile == null) break block4;
                VirtualFile virtualFile2 = psiFile.getVirtualFile();
                if (!(Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getFileType() : null), (Object)KotlinFileType.INSTANCE) ^ true)) break block5;
            }
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ent(file) ?: return false");
        Document document2 = document;
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(project, document2, line, checker){
            final /* synthetic */ Project $project;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $line;
            final /* synthetic */ Function1 $checker;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void isApplicable;
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = false;
                HashSet<E> checked = new HashSet<E>();
                XDebuggerUtil.getInstance().iterateLine(this.$project, this.$document, this.$line, (Processor)new Processor<PsiElement>(this, checked, (Ref.BooleanRef)isApplicable){
                    final /* synthetic */ isBreakpointApplicable.1 this$0;
                    final /* synthetic */ HashSet $checked;
                    final /* synthetic */ Ref.BooleanRef $isApplicable;

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean invoke(@NotNull PsiElement element) {
                        block6: {
                            block5: {
                                void $this$getParentOfType$iv;
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                if (element instanceof PsiWhiteSpace) break block5;
                                PsiElement psiElement = element;
                                boolean strict$iv = false;
                                boolean $i$f$getParentOfType = false;
                                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiComment.class, (boolean)strict$iv) == null && element.isValid()) break block6;
                            }
                            return true;
                        }
                        PsiElement parent = BreakpointTypeUtilsKt.access$getTopmostParentOnLineOrSelf(element, this.this$0.$document, this.this$0.$line);
                        if (!this.$checked.add(parent)) {
                            return true;
                        }
                        ApplicabilityResult result2 = (ApplicabilityResult)this.this$0.$checker.invoke((Object)parent);
                        if (result2.getShouldStop() && !result2.isApplicable()) {
                            this.$isApplicable.element = false;
                            return false;
                        }
                        this.$isApplicable.element |= result2.isApplicable();
                        return !result2.getShouldStop();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$checked = hashSet;
                        this.$isApplicable = booleanRef;
                    }
                });
                return isApplicable.element;
            }
            {
                this.$project = project;
                this.$document = document;
                this.$line = n;
                this.$checker = function1;
                super(0);
            }
        }));
    }

    private static final PsiElement getTopmostParentOnLineOrSelf(PsiElement element, Document document, int line) {
        int offset;
        PsiElement current = element;
        PsiElement parent = current.getParent();
        while (!(parent == null || parent instanceof PsiFile || (offset = parent.getTextOffset()) > document.getTextLength() || offset >= 0 && document.getLineNumber(offset) != line)) {
            current = parent;
            parent = current.getParent();
        }
        return current;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JavaLineBreakpointType.JavaBreakpointVariant> computeLineBreakpointVariants(@NotNull Project project, @NotNull XSourcePosition position, @NotNull KotlinLineBreakpointType kotlinBreakpointType) {
        Object element$iv2;
        LinkedList<Object> result2;
        List<KtFunction> lambdas;
        SourcePosition pos;
        block9: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)kotlinBreakpointType, (String)"kotlinBreakpointType");
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(position.getFile());
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile = (KtFile)psiFile;
            if (ktFile == null) {
                return CollectionsKt.emptyList();
            }
            KtFile file = ktFile;
            SourcePosition sourcePosition2 = pos = SourcePosition.createFromLine((PsiFile)((PsiFile)file), (int)position.getLine());
            Intrinsics.checkNotNullExpressionValue((Object)sourcePosition2, (String)"pos");
            lambdas = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(sourcePosition2);
            if (lambdas.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            result2 = new LinkedList<Object>();
            PsiElement psiElement = pos.getElementAt();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"pos.elementAt");
            Sequence $this$firstIsInstance$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)psiElement);
            boolean $i$f$firstIsInstance = false;
            for (Object element$iv2 : $this$firstIsInstance$iv) {
                if (!(element$iv2 instanceof KtElement)) continue;
                break block9;
            }
            throw (Throwable)new NoSuchElementException("No element of given type found");
        }
        KtElement elementAt = (KtElement)element$iv2;
        KtFunction mainMethod = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)elementAt), KtFunction.class, (boolean)false);
        boolean mainMethodAdded = false;
        if (mainMethod != null) {
            boolean isLambdaResult;
            KtExpression bodyExpression = mainMethod.getBodyExpression();
            boolean bl = isLambdaResult = bodyExpression instanceof KtLambdaExpression && lambdas.contains(((KtLambdaExpression)bodyExpression).getFunctionLiteral());
            if (!isLambdaResult) {
                PsiElement psiElement = CodeInsightUtils.getTopmostElementAtOffset((PsiElement)((PsiElement)elementAt), (int)pos.getOffset());
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"CodeInsightUtils.getTopm\u2026et(elementAt, pos.offset)");
                PsiElement variantElement = psiElement;
                result2.add((Object)new KotlinLineBreakpointType.LineKotlinBreakpointVariant(kotlinBreakpointType, position, variantElement, -1));
                mainMethodAdded = true;
            }
        }
        Iterable $this$forEachIndexed$iv = lambdas;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void lambda2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtFunction ktFunction = (KtFunction)item$iv;
            int ordinal = n;
            boolean bl2 = false;
            XSourcePositionImpl positionImpl = XSourcePositionImpl.createByElement((PsiElement)((PsiElement)lambda2.getBodyExpression()));
            if (positionImpl == null) continue;
            result2.add(new JavaLineBreakpointType.LambdaJavaBreakpointVariant((JavaLineBreakpointType)kotlinBreakpointType, (XSourcePosition)positionImpl, (PsiElement)lambda2, Integer.valueOf(ordinal)));
        }
        if (mainMethodAdded && result2.size() > 1) {
            result2.add((Object)new KotlinLineBreakpointType.KotlinBreakpointVariant(kotlinBreakpointType, position, lambdas.size()));
        }
        return result2;
    }

    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile = sourcePosition2.getFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file = ktFile;
        int lineNumber2 = sourcePosition2.getLine();
        return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file, lineNumber2);
    }

    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull KtFile file, int line) {
        KtFunction it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = DebuggerUtilKt.findElementAtLine(file, line);
        if (!(psiElement instanceof KtElement)) {
            psiElement = null;
        }
        KtElement ktElement = (KtElement)psiElement;
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement lineElement = ktElement;
        int start = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement));
        int end = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement));
        List list = CodeInsightUtils.findElementsOfClassInRange((PsiFile)((PsiFile)file), (int)start, (int)end, (Class[])new Class[]{KtFunction.class});
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"CodeInsightUtils.findEle\u2026, KtFunction::class.java)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtFunction)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof KtFunctionLiteral || it.getName() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set allLiterals = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$filter$iv = allLiterals;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object statement;
            it = (KtFunction)element$iv$iv;
            boolean bl = false;
            Object object = it.getBodyBlockExpression();
            if (object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.firstOrNull((List)object)) == null) {
                object = statement = (KtExpression)it;
            }
            boolean bl2 = PsiLinesUtilsKt.getLineNumber$default((PsiElement)((PsiElement)statement), (boolean)false, (int)1, null) == line && PsiLinesUtilsKt.getLineNumber((PsiElement)((PsiElement)statement), (boolean)false) == line;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isInlineOnly(@NotNull KtCallableDeclaration $this$isInlineOnly) {
        Object v2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isInlineOnly, (String)"$this$isInlineOnly");
            if (!$this$isInlineOnly.hasModifier(KtTokens.INLINE_KEYWORD)) {
                return false;
            }
            List list = $this$isInlineOnly.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotationEntries");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                KtAnnotationEntry ktAnnotationEntry = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"it");
                if (!Intrinsics.areEqual((Object)ktAnnotationEntry.getShortName(), (Object)InlineOnlyKt.getINLINE_ONLY_ANNOTATION_FQ_NAME().shortName())) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = v2;
        if (ktAnnotationEntry == null) {
            return false;
        }
        KtAnnotationEntry inlineOnlyAnnotation = ktAnnotationEntry;
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(inlineOnlyAnnotation){
            final /* synthetic */ KtAnnotationEntry $inlineOnlyAnnotation;

            public final boolean invoke() {
                BindingContext bindingContext = ResolutionUtils.analyze((KtElement)((KtElement)this.$inlineOnlyAnnotation), (BodyResolveMode)BodyResolveMode.PARTIAL);
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)this.$inlineOnlyAnnotation);
                if (annotationDescriptor == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)annotationDescriptor, (String)"bindingContext[BindingCo\u2026tation] ?: return@f false");
                AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                return Intrinsics.areEqual((Object)annotationDescriptor2.getFqName(), (Object)InlineOnlyKt.getINLINE_ONLY_ANNOTATION_FQ_NAME());
            }
            {
                this.$inlineOnlyAnnotation = ktAnnotationEntry;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ PsiElement access$getTopmostParentOnLineOrSelf(PsiElement element, Document document, int line) {
        return BreakpointTypeUtilsKt.getTopmostParentOnLineOrSelf(element, document, line);
    }
}

