/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.CssLanguageProperties;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssExpression;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.CssMediaExpression;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.CssMediaQuery;
import com.intellij.psi.css.CssMediumList;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssElementFactory {
    private final Project myProject;

    public CssElementFactory(@NotNull Project project) {
        if (project == null) {
            CssElementFactory.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static CssElementFactory getInstance(@NotNull Project project) {
        if (project == null) {
            CssElementFactory.$$$reportNull$$$0(1);
        }
        return (CssElementFactory)ServiceManager.getService((Project)project, CssElementFactory.class);
    }

    @NotNull
    public CssString createString(char quoteChar, String value, @Nullable Language language) {
        String declarationsTerminator;
        String stringText = quoteChar + value + quoteChar;
        String importText = "@import " + stringText + (declarationsTerminator = (language = CssElementFactory.getLanguage(language)) instanceof CssLanguageProperties ? ((CssLanguageProperties)language).getDeclarationsTerminator() : ";");
        CssStylesheet stylesheet = this.createStylesheet(importText, language);
        CssImport imports = (CssImport)PsiTreeUtil.findChildOfType((PsiElement)stylesheet, CssImport.class);
        CssString cssString = (CssString)PsiTreeUtil.getChildOfType((PsiElement)imports, CssString.class);
        if (cssString == null) {
            throw new IllegalArgumentException("Can't create css string with text: " + stringText);
        }
        CssString cssString2 = cssString;
        if (cssString2 == null) {
            CssElementFactory.$$$reportNull$$$0(2);
        }
        return cssString2;
    }

    @NotNull
    public PsiElement createStringToken(char quoteChar, String value, @Nullable Language language) {
        PsiElement psiElement = (PsiElement)ArrayUtil.getFirstElement((Object[])this.createString(quoteChar, value, language).getChildren());
        if (psiElement == null) {
            CssElementFactory.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public CssStylesheet createStylesheet(@NotNull String text, @Nullable Language language) {
        if (text == null) {
            CssElementFactory.$$$reportNull$$$0(4);
        }
        language = CssElementFactory.getLanguage(language);
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("_dummy_", language, (CharSequence)text, false, true);
        if (!(fileFromText instanceof StylesheetFile)) {
            throw new IllegalArgumentException("Can't create ruleset for given file type: " + fileFromText.getFileType().getName());
        }
        CssStylesheet stylesheet = ((StylesheetFile)fileFromText).getStylesheet();
        if (stylesheet == null) {
            throw new IllegalArgumentException("Can't create css stylesheet from text: " + text);
        }
        CssStylesheet cssStylesheet = stylesheet;
        if (cssStylesheet == null) {
            CssElementFactory.$$$reportNull$$$0(5);
        }
        return cssStylesheet;
    }

    @NotNull
    public CssRuleset createRuleset(@NotNull @NonNls String text, @Nullable Language language) {
        CssRuleset[] rulesets;
        if (text == null) {
            CssElementFactory.$$$reportNull$$$0(6);
        }
        if ((rulesets = this.createStylesheet(text, language).getRulesets()).length == 0) {
            throw new IllegalArgumentException("Can't create ruleset from text: " + text);
        }
        CssRuleset ruleset = rulesets[0];
        if (ruleset == null) {
            throw new IllegalArgumentException("Can't create ruleset from text: " + text);
        }
        CssRuleset cssRuleset = ruleset;
        if (cssRuleset == null) {
            CssElementFactory.$$$reportNull$$$0(7);
        }
        return cssRuleset;
    }

    @NotNull
    public CssRuleset createRuleset(@NotNull String selector, CssDeclaration @NotNull [] declarations, @Nullable Language language) {
        if (selector == null) {
            CssElementFactory.$$$reportNull$$$0(8);
        }
        if (declarations == null) {
            CssElementFactory.$$$reportNull$$$0(9);
        }
        language = CssElementFactory.getLanguage(language);
        String declarationsTerminator = CssPsiUtil.getDeclarationsTerminator(language);
        StringBuilder blockText = new StringBuilder();
        for (CssDeclaration declaration : declarations) {
            blockText.append("  ").append(declaration.getPropertyName()).append(": ");
            CssTermList declarationValue = declaration.getValue();
            if (declarationValue != null) {
                blockText.append(declarationValue.getText());
            }
            blockText.append(declarationsTerminator).append("\n");
        }
        CssRuleset cssRuleset = this.createRuleset(CssElementFactory.createRulesetText(selector, blockText, language).toString(), language);
        if (cssRuleset == null) {
            CssElementFactory.$$$reportNull$$$0(10);
        }
        return cssRuleset;
    }

    public CssDeclaration @NotNull [] createProperties(@NotNull String text, @Nullable Language language) {
        StringBuilder rulesetText;
        CssBlock block;
        if (text == null) {
            CssElementFactory.$$$reportNull$$$0(11);
        }
        if ((block = this.createRuleset((rulesetText = CssElementFactory.createRulesetText("div", new StringBuilder(text), language)).toString(), language).getBlock()) == null) {
            throw new IllegalArgumentException("Can't create css declarations from text: " + text);
        }
        CssDeclaration[] cssDeclarationArray = block.getDeclarations();
        if (cssDeclarationArray == null) {
            CssElementFactory.$$$reportNull$$$0(12);
        }
        return cssDeclarationArray;
    }

    @NotNull
    public CssDeclaration createProperty(@NotNull String propertyText, @Nullable Language language) {
        CssDeclaration[] properties;
        if (propertyText == null) {
            CssElementFactory.$$$reportNull$$$0(13);
        }
        if ((properties = this.createProperties(propertyText, language)).length == 0) {
            throw new IllegalArgumentException("Can't create css property from text: " + propertyText);
        }
        CssDeclaration cssDeclaration = properties[0];
        if (cssDeclaration == null) {
            CssElementFactory.$$$reportNull$$$0(14);
        }
        return cssDeclaration;
    }

    @NotNull
    public CssDeclaration createProperty(@NotNull String name, @NotNull String value, @Nullable Language language) {
        if (name == null) {
            CssElementFactory.$$$reportNull$$$0(15);
        }
        if (value == null) {
            CssElementFactory.$$$reportNull$$$0(16);
        }
        CssDeclaration cssDeclaration = this.createProperty(name + ": " + value + CssPsiUtil.getDeclarationsTerminator(CssElementFactory.getLanguage(language)), language);
        if (cssDeclaration == null) {
            CssElementFactory.$$$reportNull$$$0(17);
        }
        return cssDeclaration;
    }

    @NotNull
    public CssAtRule createAtRule(@NotNull String text, @NotNull Class<? extends CssAtRule> cl, @Nullable Language language) {
        if (text == null) {
            CssElementFactory.$$$reportNull$$$0(18);
        }
        if (cl == null) {
            CssElementFactory.$$$reportNull$$$0(19);
        }
        CssStylesheet stylesheet = this.createStylesheet("p {" + text + "}", language);
        CssAtRule atRule = (CssAtRule)PsiTreeUtil.findChildOfAnyType((PsiElement)stylesheet, (boolean)false, (Class[])new Class[]{cl});
        if (atRule == null) {
            throw new IllegalArgumentException(String.format("Can't create css at-rule of type %s from text: %s", cl.getSimpleName(), text));
        }
        CssAtRule cssAtRule = atRule;
        if (cssAtRule == null) {
            CssElementFactory.$$$reportNull$$$0(20);
        }
        return cssAtRule;
    }

    @Nullable
    public CssMedia createMedia(@NotNull String mediaQuery, @Nullable Language language) {
        if (mediaQuery == null) {
            CssElementFactory.$$$reportNull$$$0(21);
        }
        String mediaText = CssElementFactory.createRulesetText("@media " + mediaQuery + "{}", new StringBuilder(), language).toString();
        CssStylesheet stylesheet = this.createStylesheet(mediaText, language);
        for (CssAtRule rule : stylesheet.getRulesetList().getAtRules()) {
            if (!(rule instanceof CssMedia)) continue;
            return (CssMedia)rule;
        }
        return null;
    }

    @NotNull
    public CssMediaFeature createMediaFeature(@NotNull String name, @NotNull String value, @Nullable Language language) {
        if (name == null) {
            CssElementFactory.$$$reportNull$$$0(22);
        }
        if (value == null) {
            CssElementFactory.$$$reportNull$$$0(23);
        }
        String mediaText = CssElementFactory.createRulesetText("@media screen and (" + name + ":" + value + ")", new StringBuilder(), language).toString();
        CssStylesheet stylesheet = this.createStylesheet(mediaText, language);
        for (CssAtRule rule : stylesheet.getRulesetList().getAtRules()) {
            CssMediaExpression mediaExpression;
            CssMediaFeature mediaFeature;
            CssMediaQuery mediaQuery;
            CssMediumList mediumList;
            if (!(rule instanceof CssMedia) || (mediumList = ((CssMedia)rule).getMediumList()) == null || (mediaQuery = (CssMediaQuery)ArrayUtil.getFirstElement((Object[])mediumList.getMediaQueries())) == null || (mediaFeature = (CssMediaFeature)PsiTreeUtil.getChildOfType((PsiElement)(mediaExpression = (CssMediaExpression)ArrayUtil.getFirstElement((Object[])mediaQuery.getExpressions())), CssMediaFeature.class)) == null) continue;
            CssMediaFeature cssMediaFeature = mediaFeature;
            if (cssMediaFeature == null) {
                CssElementFactory.$$$reportNull$$$0(24);
            }
            return cssMediaFeature;
        }
        throw new IllegalArgumentException("Can't create css media feature: " + mediaText);
    }

    @NotNull
    public CssTermList createPropertyValue(@NotNull String value, @Nullable Language language) {
        CssTermList propertyValue;
        if (value == null) {
            CssElementFactory.$$$reportNull$$$0(25);
        }
        if ((propertyValue = this.createProperty("width", value, language).getValue()) == null) {
            throw new IllegalArgumentException("Can't create css property value: " + value);
        }
        CssTermList cssTermList = propertyValue;
        if (cssTermList == null) {
            CssElementFactory.$$$reportNull$$$0(26);
        }
        return cssTermList;
    }

    @NotNull
    public CssDescriptorOwner createFunction(@NotNull String name, @Nullable Language language) {
        CssTerm term;
        CssFunction function;
        if (name == null) {
            CssElementFactory.$$$reportNull$$$0(27);
        }
        if ((function = (CssFunction)PsiTreeUtil.findChildOfType((PsiElement)(term = this.createTerm(name + "(param)", language)), CssFunction.class)) == null) {
            throw new IllegalArgumentException("Can't create css function with name: " + name);
        }
        CssFunction cssFunction = function;
        if (cssFunction == null) {
            CssElementFactory.$$$reportNull$$$0(28);
        }
        return cssFunction;
    }

    @NotNull
    public CssTerm createTerm(@NotNull String value, @Nullable Language language) {
        CssTermList propertyValue;
        CssTerm term;
        if (value == null) {
            CssElementFactory.$$$reportNull$$$0(29);
        }
        if ((term = (CssTerm)PsiTreeUtil.findChildOfType((PsiElement)(propertyValue = this.createPropertyValue(value, language)), CssTerm.class)) == null) {
            throw new IllegalArgumentException("Can't create css term with value: " + value);
        }
        CssTerm cssTerm = term;
        if (cssTerm == null) {
            CssElementFactory.$$$reportNull$$$0(30);
        }
        return cssTerm;
    }

    @NotNull
    public CssElement createExpressionParameter(@NotNull String value, @Nullable Language language) {
        CssTermList propertyValue;
        CssExpression expression;
        CssElement expressionParameter;
        if (value == null) {
            CssElementFactory.$$$reportNull$$$0(31);
        }
        CssElement cssElement = expressionParameter = (expression = (CssExpression)PsiTreeUtil.findChildOfType((PsiElement)(propertyValue = this.createPropertyValue("expression(" + value + ")", language)), CssExpression.class)) != null ? expression.getValueNode() : null;
        if (expressionParameter == null) {
            throw new IllegalArgumentException("Can't create css expression with value: " + value);
        }
        CssElement cssElement2 = expressionParameter;
        if (cssElement2 == null) {
            CssElementFactory.$$$reportNull$$$0(32);
        }
        return cssElement2;
    }

    @NotNull
    public CssPseudoSelector createPseudoSelector(String name, @Nullable Language language) {
        CssPseudoSelector cssPseudoSelector = this.createPseudoSelector(name, language, false);
        if (cssPseudoSelector == null) {
            CssElementFactory.$$$reportNull$$$0(33);
        }
        return cssPseudoSelector;
    }

    @NotNull
    public CssPseudoSelector createPseudoSelector(String name, @Nullable Language language, boolean isEscaped) {
        assert (name.startsWith(":"));
        Object selector = isEscaped ? "\\" + name : name;
        CssRuleset ruleset = this.createRuleset(CssElementFactory.createRulesetText((String)selector, new StringBuilder(), language).toString(), language);
        CssPseudoSelector pseudoSelector = (CssPseudoSelector)PsiTreeUtil.findChildOfType((PsiElement)ruleset, CssPseudoSelector.class);
        if (pseudoSelector == null) {
            throw new IllegalArgumentException("Can't create css pseudo selector from text: " + name);
        }
        CssPseudoSelector cssPseudoSelector = pseudoSelector;
        if (cssPseudoSelector == null) {
            CssElementFactory.$$$reportNull$$$0(34);
        }
        return cssPseudoSelector;
    }

    @NotNull
    public CssSelectorList createSelectorList(@NotNull String text, @Nullable Language language) {
        CssRuleset ruleset;
        CssSelectorList selectorList;
        if (text == null) {
            CssElementFactory.$$$reportNull$$$0(35);
        }
        if ((selectorList = (CssSelectorList)PsiTreeUtil.findChildOfType((PsiElement)(ruleset = this.createRuleset(CssElementFactory.createRulesetText(text, new StringBuilder(), language).toString(), language)), CssSelectorList.class)) == null) {
            throw new IllegalArgumentException("Can't create css selector list from text: " + text);
        }
        CssSelectorList cssSelectorList = selectorList;
        if (cssSelectorList == null) {
            CssElementFactory.$$$reportNull$$$0(36);
        }
        return cssSelectorList;
    }

    @NotNull
    public CssSimpleSelector createSimpleSelector(@NotNull String simpleSelectorText, @Nullable Language language) {
        CssRuleset ruleset;
        CssSimpleSelector simpleSelector;
        if (simpleSelectorText == null) {
            CssElementFactory.$$$reportNull$$$0(37);
        }
        if ((simpleSelector = (CssSimpleSelector)PsiTreeUtil.findChildOfType((PsiElement)(ruleset = this.createRuleset(simpleSelectorText + " {}", language)), CssSimpleSelector.class)) == null) {
            throw new IllegalArgumentException("Can't create css simple selector from text: " + simpleSelectorText);
        }
        CssSimpleSelector cssSimpleSelector = simpleSelector;
        if (cssSimpleSelector == null) {
            CssElementFactory.$$$reportNull$$$0(38);
        }
        return cssSimpleSelector;
    }

    @NotNull
    public CssImportList createImportList(@Nullable Language language, String ... imports) {
        String text = StringUtil.join((String[])imports, (String)CssPsiUtil.getDeclarationsTerminator(language));
        CssStylesheet stylesheet = this.createStylesheet(text, language);
        CssImportList importList = stylesheet.getImportList();
        if (importList == null) {
            throw new IllegalArgumentException("Can't create css import list from text: " + text);
        }
        CssImportList cssImportList = importList;
        if (cssImportList == null) {
            CssElementFactory.$$$reportNull$$$0(39);
        }
        return cssImportList;
    }

    @NotNull
    public PsiElement createToken(@NotNull String text, @Nullable Language language) {
        PsiElement result;
        if (text == null) {
            CssElementFactory.$$$reportNull$$$0(40);
        }
        language = CssElementFactory.getLanguage(language);
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("_dummy_", language, (CharSequence)text, false, true);
        PsiElement leaf = PsiTreeUtil.getDeepestFirst((PsiElement)fileFromText);
        PsiElement psiElement = result = leaf instanceof PsiErrorElement ? PsiTreeUtil.nextVisibleLeaf((PsiElement)leaf) : leaf;
        if (result == null) {
            throw new IllegalArgumentException("Can't create css token from text: " + text);
        }
        PsiElement psiElement2 = result;
        if (psiElement2 == null) {
            CssElementFactory.$$$reportNull$$$0(41);
        }
        return psiElement2;
    }

    @NotNull
    public CssUri createUri(String string, @Nullable Language language) {
        CssTermList termList = this.createPropertyValue("url(" + string + ")", language);
        CssUri cssUri = (CssUri)PsiTreeUtil.findChildOfType((PsiElement)termList, CssUri.class);
        if (cssUri == null) {
            throw new IllegalArgumentException("Can't create css uri with value: " + string);
        }
        CssUri cssUri2 = cssUri;
        if (cssUri2 == null) {
            CssElementFactory.$$$reportNull$$$0(42);
        }
        return cssUri2;
    }

    @NotNull
    private static Language getLanguage(@Nullable Language language) {
        CSSLanguage cSSLanguage = language != null && language.isKindOf((Language)CSSLanguage.INSTANCE) ? language : CSSLanguage.INSTANCE;
        if (cSSLanguage == null) {
            CssElementFactory.$$$reportNull$$$0(43);
        }
        return cSSLanguage;
    }

    @NotNull
    private static StringBuilder createRulesetText(@NotNull String selector, @NotNull StringBuilder blockText, @Nullable Language language) {
        boolean identBasedCssLanguage;
        if (selector == null) {
            CssElementFactory.$$$reportNull$$$0(44);
        }
        if (blockText == null) {
            CssElementFactory.$$$reportNull$$$0(45);
        }
        if (identBasedCssLanguage = CssPsiUtil.isIndentBasedCssLanguage(CssElementFactory.getLanguage(language))) {
            if (!blockText.toString().startsWith(" ")) {
                blockText.insert(0, "\n  ");
            } else {
                blockText.insert(0, '\n');
            }
        } else {
            blockText.insert(0, " {\n");
        }
        blockText.insert(0, selector);
        if (!identBasedCssLanguage) {
            blockText.append('}');
        }
        StringBuilder stringBuilder = blockText;
        if (stringBuilder == null) {
            CssElementFactory.$$$reportNull$$$0(46);
        }
        return stringBuilder;
    }

    @NotNull
    public CssImport createImport(@NotNull String importPath, @Nullable Language language) {
        CssStylesheet stylesheet;
        CssImport cssImport;
        if (importPath == null) {
            CssElementFactory.$$$reportNull$$$0(47);
        }
        if ((cssImport = (CssImport)ContainerUtil.getFirstItem((stylesheet = this.createStylesheet("@import '" + importPath + "'", CssElementFactory.getLanguage(language))).getImports(false))) == null) {
            throw new IllegalArgumentException("Can't create css import with import path: " + importPath + " and language: " + language);
        }
        CssImport cssImport2 = cssImport;
        if (cssImport2 == null) {
            CssElementFactory.$$$reportNull$$$0(48);
        }
        return cssImport2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/CssElementFactory";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 18: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyText";
                break;
            }
            case 15: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 23: 
            case 25: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mediaQuery";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleSelectorText";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockText";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/CssElementFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringToken";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createStylesheet";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRuleset";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createProperties";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createProperty";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createAtRule";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createMediaFeature";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createPropertyValue";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunction";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerm";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionParameter";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createPseudoSelector";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectorList";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleSelector";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportList";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createToken";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createUri";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createRulesetText";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStylesheet";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRuleset";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProperties";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createAtRule";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createMedia";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createMediaFeature";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyValue";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createFunction";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createTerm";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionParameter";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createSelectorList";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleSelector";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createToken";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createRulesetText";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

