/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.CssLanguageProperties;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBracketedList;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.CssOperation;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssPsiUtil {
    @NonNls
    private static final String EMPTY_STRING = "";

    private CssPsiUtil() {
    }

    @Nullable
    public static CssDeclaration findDeclaration(@NotNull CssBlock cssBlock, @NotNull String propertyName, boolean searchInShorthand) {
        if (cssBlock == null) {
            CssPsiUtil.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            CssPsiUtil.$$$reportNull$$$0(1);
        }
        for (CssDeclaration declaration : cssBlock.getDeclarations()) {
            List<String> propertyNames;
            if (propertyName.equalsIgnoreCase(declaration.getPropertyName())) {
                return declaration;
            }
            if (!searchInShorthand || !declaration.isShorthandProperty() || !(propertyNames = Arrays.asList(declaration.expandShorthandProperty())).contains(propertyName)) continue;
            return declaration;
        }
        return null;
    }

    public static PsiElement findToken(@NotNull CssElement cssElement, @NotNull TokenSet tokenSet) {
        ASTNode childByType;
        if (cssElement == null) {
            CssPsiUtil.$$$reportNull$$$0(2);
        }
        if (tokenSet == null) {
            CssPsiUtil.$$$reportNull$$$0(3);
        }
        if ((childByType = cssElement.getNode().findChildByType(tokenSet)) != null) {
            return childByType.getPsi();
        }
        for (PsiElement element : cssElement.getChildren()) {
            PsiElement token;
            if (element instanceof ASTNode && tokenSet.contains(((ASTNode)element).getElementType())) {
                return element;
            }
            if (!(element instanceof CssElement) || (token = CssPsiUtil.findToken((CssElement)element, tokenSet)) == null) continue;
            return token;
        }
        return null;
    }

    @NotNull
    public static Set<String> getRulesetTags(@NotNull CssRuleset ruleset) {
        if (ruleset == null) {
            CssPsiUtil.$$$reportNull$$$0(4);
        }
        HashSet<String> result = new HashSet<String>();
        for (CssSelector selector : ruleset.getSelectors()) {
            CssSimpleSelector lastElement = (CssSimpleSelector)ArrayUtil.getLastElement((Object[])selector.getSimpleSelectors());
            if (lastElement == null) continue;
            result.add(lastElement.getElementName());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            CssPsiUtil.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public static boolean isInFunction(@Nullable PsiElement element) {
        CssValueOwner termListOwner = (CssValueOwner)PsiTreeUtil.getParentOfType((PsiElement)element, CssValueOwner.class);
        return termListOwner instanceof CssFunction;
    }

    public static TextRange getValueTextRange(@NotNull CssValueOwner valueOwner) {
        CssTermList termList;
        if (valueOwner == null) {
            CssPsiUtil.$$$reportNull$$$0(6);
        }
        return (termList = valueOwner.getValue()) != null ? termList.getTextRange() : TextRange.EMPTY_RANGE;
    }

    @Nullable
    public static Language getStylesheetLanguage(@Nullable PsiElement context) {
        try {
            PsiElement element;
            if (context == null) {
                return null;
            }
            Language contextLanguage = context.getLanguage();
            if (contextLanguage != Language.ANY && !contextLanguage.isKindOf((Language)CSSLanguage.INSTANCE)) {
                return null;
            }
            if (context instanceof StylesheetFile || context instanceof CssStylesheet) {
                return contextLanguage;
            }
            if (context instanceof CssElement) {
                if (!(context instanceof StubBasedPsiElement) && context.getFirstChild() == null) {
                    Language parentLanguage;
                    PsiElement obj = context.getParent();
                    Language language = parentLanguage = obj == null ? null : obj.getLanguage();
                    if (parentLanguage != null && parentLanguage.isKindOf((Language)CSSLanguage.INSTANCE)) {
                        return parentLanguage;
                    }
                } else {
                    return contextLanguage;
                }
            }
            if ((element = PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{CssElement.class})) != null) {
                return element.getLanguage();
            }
        }
        catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static String getDeclarationsTerminator(@Nullable Language language) {
        return language instanceof CssLanguageProperties ? ((CssLanguageProperties)language).getDeclarationsTerminator() : ";";
    }

    @NotNull
    public static String getDeclarationsTerminatorFromContext(@Nullable PsiElement context) {
        CssLanguageProperties languageProperties = CssPsiUtil.getLanguagePropertiesFromContext(context);
        return languageProperties != null ? languageProperties.getDeclarationsTerminator() : ";";
    }

    public static boolean isIndentBasedCssLanguage(@Nullable Language language) {
        return language instanceof CssLanguageProperties && ((CssLanguageProperties)language).isIndentBased();
    }

    public static boolean isIndentBasedCssLanguage(@Nullable PsiElement context) {
        CssLanguageProperties languageProperties = CssPsiUtil.getLanguagePropertiesFromContext(context);
        return languageProperties != null && languageProperties.isIndentBased();
    }

    @Nullable
    private static CssLanguageProperties getLanguagePropertiesFromContext(@Nullable PsiElement context) {
        Language stylesheetLanguage = CssPsiUtil.getStylesheetLanguage(context);
        if (stylesheetLanguage instanceof CssLanguageProperties) {
            return (CssLanguageProperties)stylesheetLanguage;
        }
        return null;
    }

    public static PsiElement getFirstDeepestTerm(@Nullable PsiElement element) {
        if (element instanceof CssTermList) {
            PsiElement term = PsiTreeUtil.getNonStrictParentOfType((PsiElement)PsiTreeUtil.getDeepestFirst((PsiElement)element), (Class[])new Class[]{CssTerm.class});
            if (term != null) {
                PsiElement parent = term.getParent();
                while (parent instanceof CssOperation) {
                    term = parent;
                    parent = term.getParent();
                }
            }
            return term;
        }
        if (element instanceof CssBracketedList) {
            return element.getFirstChild();
        }
        return element;
    }

    public static PsiElement getLastDeepestTerm(@Nullable PsiElement element) {
        if (element instanceof CssTermList) {
            PsiElement term = PsiTreeUtil.getNonStrictParentOfType((PsiElement)PsiTreeUtil.getDeepestLast((PsiElement)element), (Class[])new Class[]{CssTerm.class});
            if (term != null) {
                PsiElement parent = term.getParent();
                while (parent instanceof CssOperation) {
                    term = parent;
                    parent = term.getParent();
                }
            }
            return term;
        }
        return element;
    }

    @NotNull
    public static String getTokenText(@Nullable PsiElement element) {
        String string = element == null ? EMPTY_STRING : element.getText();
        if (string == null) {
            CssPsiUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static PsiElement replaceToken(@NotNull PsiElement token, String value) throws IncorrectOperationException {
        if (token == null) {
            CssPsiUtil.$$$reportNull$$$0(8);
        }
        return ElementManipulators.handleContentChange((PsiElement)token, (TextRange)new TextRange(0, token.getTextLength()), (String)value);
    }

    public static int hashCodeForElement(@Nullable PsiElement element) {
        if (element == null || element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            return 0;
        }
        return new CssHashingVisitor().calculate(element);
    }

    @NotNull
    public static Set<CssMediaType> getAllowedMediaTypesInContext(@Nullable PsiElement context) {
        CssMedia customMedia;
        String attributeValue;
        CssMedia media = (CssMedia)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssMedia.class});
        if (media != null) {
            Set<CssMediaType> set = media.getMediaTypes();
            if (set == null) {
                CssPsiUtil.$$$reportNull$$$0(9);
            }
            return set;
        }
        HtmlTag htmlTag = (HtmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{HtmlTag.class});
        if (htmlTag != null && "style".equals(htmlTag.getName()) && StringUtil.isNotEmpty((String)(attributeValue = htmlTag.getAttributeValue("media"))) && (customMedia = CssElementFactory.getInstance(context.getProject()).createMedia(attributeValue, CSSLanguage.INSTANCE)) != null) {
            Set<CssMediaType> set = customMedia.getMediaTypes();
            if (set == null) {
                CssPsiUtil.$$$reportNull$$$0(10);
            }
            return set;
        }
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new CssMediaType[]{CssMediaType.ALL});
        if (hashSet == null) {
            CssPsiUtil.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    public static boolean isCustomVariableReference(@NotNull PsiElement element) {
        PsiElement termList;
        PsiElement parent;
        if (element == null) {
            CssPsiUtil.$$$reportNull$$$0(12);
        }
        if ((parent = element.getParent()) instanceof CssTerm && (termList = parent.getParent()) instanceof CssTermList) {
            PsiElement function = termList.getParent();
            if (function instanceof CssTermList && function.getChildren().length == 1) {
                function = function.getParent();
            }
            if (function instanceof CssFunction && "var".equalsIgnoreCase(((CssFunction)function).getName())) {
                CssTerm[] terms = ((CssTermList)termList).getTerms();
                return terms.length == 1 || terms.length == 2 && parent.getPrevSibling() == null;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleset";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/css/util/CssPsiUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueOwner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/css/util/CssPsiUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesetTags";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedMediaTypesInContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findToken";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRulesetTags";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValueTextRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceToken";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCustomVariableReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CssHashingVisitor
    extends CssElementVisitor {
        private int myResult = 0;

        private CssHashingVisitor() {
        }

        public int calculate(@NotNull PsiElement element) {
            if (element == null) {
                CssHashingVisitor.$$$reportNull$$$0(0);
            }
            this.myResult = 0;
            element.accept((PsiElementVisitor)this);
            return this.myResult;
        }

        @Override
        public void visitCssUri(CssUri uri) {
            this.myResult += 31 * uri.getNode().getElementType().hashCode() + 31 * uri.getValue().hashCode();
        }

        @Override
        public void visitCssString(CssString _string) {
            this.myResult += 31 * _string.getNode().getElementType().hashCode() + 31 * _string.getText().hashCode();
        }

        @Override
        public void visitCssTerm(CssTerm _term) {
            this.myResult += 31 * _term.getTermType().hashCode();
            super.visitCssElement(_term);
        }

        @Override
        public void visitCssDeclaration(CssDeclaration declaration) {
            this.myResult += declaration.equalityHashCode();
        }

        @Override
        public void visitCssElement(CssElement element) {
            if (element instanceof CssValueOwner) {
                String name;
                CssTermList value = ((CssValueOwner)element).getValue();
                if (value != null) {
                    value.accept(this);
                }
                if (element instanceof CssNamedElement && (name = ((CssNamedElement)element).getName()) != null) {
                    this.myResult += 31 * StringUtil.toLowerCase((String)name).hashCode();
                }
                return;
            }
            super.visitCssElement(element);
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                CssHashingVisitor.$$$reportNull$$$0(1);
            }
            if (!(element instanceof PsiComment) && !(element instanceof PsiWhiteSpace)) {
                this.myResult += 31 * element.getNode().getElementType().hashCode();
                if (element.getChildren().length == 0) {
                    this.myResult += 31 * StringUtil.toLowerCase((String)element.getText()).hashCode();
                } else {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }
            super.visitElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/css/util/CssPsiUtil$CssHashingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

