/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.ResponseType;
import com.intellij.tasks.generic.Selector;
import com.intellij.tasks.generic.SelectorBasedResponseHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="XPathResponseHandler")
public final class XPathResponseHandler
extends SelectorBasedResponseHandler {
    private final Map<String, XPath> myCompiledCache = new HashMap<String, XPath>();

    public XPathResponseHandler() {
    }

    public XPathResponseHandler(GenericRepository repository) {
        super(repository);
    }

    @Override
    @NotNull
    protected List<Object> selectTasksList(@NotNull String response, int max) throws Exception {
        if (response == null) {
            XPathResponseHandler.$$$reportNull$$$0(0);
        }
        Document document = new SAXBuilder(false).build((Reader)new StringReader(response));
        Element root = document.getRootElement();
        XPath xPath = this.lazyCompile(this.getSelector("tasks").getPath());
        List rawTaskElements = xPath.selectNodes((Object)root);
        if (!rawTaskElements.isEmpty() && !(rawTaskElements.get(0) instanceof Element)) {
            throw new Exception(String.format("Expression '%s' should match list of XML elements. Got '%s' instead.", xPath.getXPath(), rawTaskElements.toString()));
        }
        List list = ContainerUtil.getFirstItems((List)rawTaskElements, (int)max);
        if (list == null) {
            XPathResponseHandler.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    protected String selectString(@NotNull Selector selector, @NotNull Object context) throws Exception {
        if (selector == null) {
            XPathResponseHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            XPathResponseHandler.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)selector.getPath())) {
            return null;
        }
        XPath xPath = this.lazyCompile(selector.getPath());
        String s = xPath.valueOf(context);
        if (s == null) {
            throw new Exception(String.format("XPath expression '%s' doesn't match", xPath.getXPath()));
        }
        return s;
    }

    @NotNull
    private XPath lazyCompile(@NotNull String path) throws Exception {
        XPath xPath;
        if (path == null) {
            XPathResponseHandler.$$$reportNull$$$0(4);
        }
        if ((xPath = this.myCompiledCache.get(path)) == null) {
            try {
                xPath = XPath.newInstance((String)path);
                this.myCompiledCache.put(path, xPath);
            }
            catch (JDOMException e) {
                throw new Exception(String.format("Malformed XPath expression '%s'", path));
            }
        }
        XPath xPath2 = xPath;
        if (xPath2 == null) {
            XPathResponseHandler.$$$reportNull$$$0(5);
        }
        return xPath2;
    }

    @Override
    @NotNull
    public ResponseType getResponseType() {
        ResponseType responseType = ResponseType.XML;
        if (responseType == null) {
            XPathResponseHandler.$$$reportNull$$$0(6);
        }
        return responseType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/generic/XPathResponseHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/generic/XPathResponseHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "selectTasksList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "lazyCompile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectTasksList";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lazyCompile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

