/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui.editors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ui.AbstractDomElementComponent;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CommittableUtil;
import com.intellij.util.xml.ui.DomElementComponent;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.editors.AbstractDomElementEditor;

public class BasicDomElementEditor
extends AbstractDomElementEditor {
    private AbstractDomElementComponent myDomElementComponent;

    @Override
    public String getEditorDescription() {
        return this.getDomElement().getXmlElementName();
    }

    @Override
    public void doInit(DomElement domElement) {
        this.myDomElementComponent = this.getDomElementComponent(domElement);
        if (domElement != null) {
            DomUIFactory.getDomUIFactory().setupErrorOutdatingUserActivityWatcher((CommittablePanel)this.myDomElementComponent, new DomElement[]{domElement});
        }
        Disposer.register((Disposable)this, (Disposable)this.myDomElementComponent);
    }

    public AbstractDomElementComponent getDomElementComponent(DomElement domElement) {
        return new DomElementComponent(domElement);
    }

    @Override
    public void refreshEditor() {
        if (this.getDomElement() != null && this.getDomElement().isValid() && this.myDomElementComponent != null) {
            this.myDomElementComponent.reset();
        }
    }

    @Override
    public void commitEditor() {
        DomElement domElement = this.myDomElementComponent.getDomElement();
        Project project = domElement.getManager().getProject();
        ((CommittableUtil)ServiceManager.getService((Project)project, CommittableUtil.class)).commit((Committable)this.myDomElementComponent);
    }

    @Override
    public AbstractDomElementComponent getComponent() {
        return this.myDomElementComponent;
    }

    public void dispose() {
    }
}

