/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.ui.AbstractDomElementComponent;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.DomUIFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.reflect.Type;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DomElementComponent
extends AbstractDomElementComponent {
    private JScrollPane myScrollPane;
    private JPanel myRootPane;
    private JPanel myPropertiesPane;
    private JLabel myLabel;

    public DomElementComponent(DomElement domElement) {
        super(domElement);
        this.$$$setupUI$$$();
        if (domElement == null) {
            return;
        }
        this.initLabel();
        this.initProperties();
        this.myRootPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void initLabel() {
        this.myLabel.setText(this.getDomElement() != null ? this.getDomElement().getPresentation().getElementName() : "");
        this.myLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.black));
        Font defaultFont = this.myLabel.getFont();
        this.myLabel.setFont(new Font(defaultFont.getName(), 1, defaultFont.getSize() + 2));
    }

    private void initProperties() {
        this.myPropertiesPane.setLayout(new GridBagLayout());
        int rowId = 0;
        for (AbstractDomChildrenDescription description : this.getDomElement().getGenericInfo().getChildrenDescriptions()) {
            if (description instanceof DomFixedChildDescription && DomUtil.isGenericValueType((Type)description.getType())) {
                String presentableName = ((DomFixedChildDescription)description).getCommonPresentableName(this.getDomElement());
                List values = description.getValues(this.getDomElement());
                if (values.size() == 1) {
                    this.addControl(DomUIFactory.createControl((GenericDomValue)((GenericDomValue)values.get(0))), rowId++, presentableName);
                    continue;
                }
                for (int i = 0; i < values.size(); ++i) {
                    this.addControl(DomUIFactory.createControl((GenericDomValue)((GenericDomValue)values.get(i))), rowId++, presentableName + " " + i);
                }
                continue;
            }
            if (!(description instanceof DomCollectionChildDescription)) continue;
            DomUIControl control = DomUIFactory.getDomUIFactory().createCollectionControl(this.getDomElement(), (DomCollectionChildDescription)description);
            this.addCollectionControl(control, rowId++);
        }
        this.addComponent(new JPanel(), 0, rowId, 2, 1.0, 1.0, 1);
    }

    private void addControl(DomUIControl control, int rowId, @NlsSafe String tagName) {
        this.addComponent(new JLabel(tagName), 0, rowId, 1, 0.0, 0.0);
        this.addComponent(control.getComponent(), 1, rowId, 1, 1.0, 0.0);
        this.addComponent((Committable)control);
    }

    private void addCollectionControl(DomUIControl control, int rowId) {
        this.addComponent((Committable)control);
        JComponent component = control.getComponent();
        component.setMinimumSize(new Dimension((int)component.getPreferredSize().getWidth(), 150));
        this.addComponent(component, 0, rowId, 2, 1.0, 0.0);
    }

    private void addComponent(JComponent component, int x, int y, int gridWidth, double weightx, double weighty) {
        this.addComponent(component, x, y, gridWidth, weightx, weighty, 2);
    }

    private void addComponent(JComponent component, int x, int y, int gridWidth, double weightx, double weighty, int fill) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = fill;
        c.gridwidth = gridWidth;
        c.gridx = x;
        c.gridy = y;
        c.weightx = weightx;
        c.weighty = weighty;
        c.anchor = 18;
        this.myPropertiesPane.add((Component)component, c);
    }

    public final JComponent getComponent() {
        DomElementComponent.setEnabled((Component)this.myRootPane, (this.getDomElement() != null ? 1 : 0) != 0);
        return this.myScrollPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myScrollPane = jBScrollPane;
        this.myRootPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel2);
        this.myLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPropertiesPane = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myScrollPane;
    }
}

