/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetCommonPart;
import com.intellij.javaee.facet.JavaeeFacetEx;
import com.intellij.javaee.facet.JavaeeFacetListener;
import com.intellij.javaee.model.xml.WebAppVersion;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebModelImpl;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetConfigurationImpl;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebFacetImpl
extends WebFacet
implements JavaeeFacetEx,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.web.facet.WebFacetImpl");
    private CachedValue<Map<String, String>> myTaglibUriToResource;
    private final JavaeeFacetCommonPart myCommonPart;
    private final List<WebRoot> myWebRoots;
    private boolean myWebSourceRootsNotSpecified;
    @NonNls
    public static final String WEB_FRAGMENT_XML = "web-fragment.xml";

    public WebFacetImpl(@NotNull WebFacetType facetType, @NotNull Module module, String name, @NotNull WebFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            WebFacetImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            WebFacetImpl.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            WebFacetImpl.$$$reportNull$$$0(2);
        }
        super((FacetType)facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
        this.myWebRoots = new ArrayList<WebRoot>();
        this.myCommonPart = new JavaeeFacetCommonPart((JavaeeFacet)this, (ConfigFileMetaDataProvider)facetType.getDescriptorsMetaDataProvider(), configuration.getDescriptorsConfiguration());
        for (WebRootData data : configuration.getWebRoots()) {
            this.addWebRoot(data);
        }
        Disposer.register((Disposable)this, (Disposable)this.myCommonPart);
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myCommonPart.getDescriptorsContainer();
    }

    public ModificationTracker getModificationTracker() {
        return this.myCommonPart.getModificationTracker();
    }

    public JavaeeFacetCommonPart getCommonPart() {
        return this.myCommonPart;
    }

    public void addFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.addListener(listener);
    }

    public void removeFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.removeListener(listener);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myWebSourceRootsNotSpecified = element == null || element.getChild("sourceRoots") == null;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String[] sourceRoots = ModuleRootManager.getInstance((Module)this.getModule()).getSourceRootUrls();
        if (Comparing.haveEqualElements(this.getWebConfiguration().getSourceRoots(), Arrays.asList(sourceRoots))) {
            element.removeChild("sourceRoots");
        }
    }

    public void setWebRoots(@NotNull List<WebRootData> webRoots) {
        if (webRoots == null) {
            WebFacetImpl.$$$reportNull$$$0(3);
        }
        this.myWebRoots.clear();
        this.getWebConfiguration().setWebRoots(webRoots);
        this.myWebRoots.clear();
        for (WebRootData data : this.getWebConfiguration().getWebRoots()) {
            this.addWebRoot(data);
        }
        this.fireWebRootsListeners();
    }

    public void removeAllWebRoots() {
        this.myWebRoots.clear();
        this.getWebConfiguration().setWebRoots(Collections.emptyList());
        this.fireWebRootsListeners();
    }

    public WebRoot addWebRoot(@NotNull String directoryUrl, @NotNull String relativePath) {
        if (directoryUrl == null) {
            WebFacetImpl.$$$reportNull$$$0(4);
        }
        if (relativePath == null) {
            WebFacetImpl.$$$reportNull$$$0(5);
        }
        WebRoot webRoot2 = this.addWebRootNoFire(directoryUrl, relativePath);
        this.fireWebRootsListeners();
        ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManagerEx.getInstanceEx((Project)this.getModule().getProject()).makeRootsChange(EmptyRunnable.getInstance(), false, true));
        return webRoot2;
    }

    public WebRoot addWebRoot(@NotNull VirtualFile directory, @NotNull String relativePath) {
        if (directory == null) {
            WebFacetImpl.$$$reportNull$$$0(6);
        }
        if (relativePath == null) {
            WebFacetImpl.$$$reportNull$$$0(7);
        }
        return this.addWebRoot(directory.getUrl(), relativePath);
    }

    public void removeWebRoot(WebRoot webRoot2) {
        if (this.myWebRoots.remove(webRoot2)) {
            this.getWebConfiguration().removeWebRoot(new WebRootData(webRoot2.getDirectoryUrl(), webRoot2.getRelativePath()));
            Disposer.dispose((Disposable)webRoot2);
            this.fireWebRootsListeners();
        }
    }

    public WebRoot addWebRootNoFire(@NotNull String directoryUrl, @NotNull String relativePath) {
        if (directoryUrl == null) {
            WebFacetImpl.$$$reportNull$$$0(8);
        }
        if (relativePath == null) {
            WebFacetImpl.$$$reportNull$$$0(9);
        }
        WebRootData data = new WebRootData(directoryUrl, relativePath);
        this.getWebConfiguration().addWebRoot(data);
        return this.addWebRoot(data);
    }

    public List<WebRoot> getWebRoots() {
        return this.getWebRoots(false);
    }

    private WebRoot addWebRoot(WebRootData data) {
        WebRoot webRoot2 = new WebRoot(data.getUrl(), data.getRelativePath());
        Disposer.register((Disposable)this, (Disposable)webRoot2);
        this.myWebRoots.add(webRoot2);
        return webRoot2;
    }

    public WebFacetConfigurationImpl getWebConfiguration() {
        return (WebFacetConfigurationImpl)this.getConfiguration();
    }

    private void fireWebRootsListeners() {
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public Collection<VirtualFile> getSourceRoots() {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        for (String url : this.getWebConfiguration().getSourceRoots()) {
            VirtualFile file = fileManager.findFileByUrl(url);
            if (file == null) continue;
            list.add(file);
        }
        return list;
    }

    public List<WebRoot> getWebRoots(boolean includeDependentModules) {
        return Collections.unmodifiableList(this.myWebRoots);
    }

    private void addFragments(List<XmlFile> files) {
        Project project = this.getModule().getProject();
        PsiPackage metaInf = JavaPsiFacade.getInstance((Project)project).findPackage("META-INF");
        if (metaInf != null) {
            for (PsiDirectory directory : metaInf.getDirectories()) {
                PsiFile file = directory.findFile(WEB_FRAGMENT_XML);
                if (!(file instanceof XmlFile)) continue;
                files.add((XmlFile)file);
            }
        }
    }

    public List<PsiDirectory> getResources() {
        Project project = this.getModule().getProject();
        PsiPackage metainf = JavaPsiFacade.getInstance((Project)project).findPackage("META-INF");
        if (metainf == null) {
            return Collections.emptyList();
        }
        Object[] directories = metainf.getDirectories(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.getModule()));
        return ContainerUtil.mapNotNull((Object[])directories, (Function)((NullableFunction)psiDirectory -> psiDirectory.findSubdirectory("resources")));
    }

    @Nullable
    public WebApp getRoot() {
        List<WebApp> models = this.getWebApps();
        return models.isEmpty() ? null : (WebApp)DomManager.getDomManager((Project)this.getModule().getProject()).createModelMerger().mergeModels(WebApp.class, models);
    }

    @NotNull
    public WebAppVersion getWebAppVersion() {
        WebApp webApp = this.getRoot();
        if (webApp == null) {
            WebAppVersion webAppVersion = WebAppVersion.WebAppVersion_3_0;
            if (webAppVersion == null) {
                WebFacetImpl.$$$reportNull$$$0(10);
            }
            return webAppVersion;
        }
        WebAppVersion value = (WebAppVersion)webApp.getVersion().getValue();
        WebAppVersion webAppVersion = value == null ? WebAppVersion.WebAppVersion_2_4 : value;
        if (webAppVersion == null) {
            WebFacetImpl.$$$reportNull$$$0(11);
        }
        return webAppVersion;
    }

    public List<WebApp> getWebApps() {
        ArrayList<XmlFile> files = new ArrayList<XmlFile>();
        ConfigFile deploymentDescriptor = this.getWebXmlDescriptor();
        if (deploymentDescriptor != null) {
            XmlFile xmlFile = deploymentDescriptor.getXmlFile();
            ContainerUtil.addIfNotNull(files, (Object)xmlFile);
        }
        this.addFragments(files);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        return ContainerUtil.mapNotNull(files, (Function)((NullableFunction)file -> (WebApp)JamCommonUtil.getRootElement((PsiFile)file, WebApp.class)));
    }

    @NotNull
    public WebModel getWebModel() {
        return new WebModelImpl(this);
    }

    public void onFacetChanged() {
        this.refreshModel();
    }

    public Map<String, String> getTaglibUriToResourceMap() {
        if (this.myTaglibUriToResource == null) {
            PsiManager manager = PsiManager.getInstance((Project)this.getModule().getProject());
            this.myTaglibUriToResource = CachedValuesManager.getManager((Project)manager.getProject()).createCachedValue(() -> {
                XmlTag webXmlRootTag = this.getWebXmlRootTag();
                if (webXmlRootTag == null) {
                    return new CachedValueProvider.Result(new HashMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                XmlTag configTag = webXmlRootTag.findFirstSubTag("jsp-config");
                XmlTag[] taglibTags = configTag != null ? configTag.findSubTags("taglib") : webXmlRootTag.findSubTags("taglib");
                HashMap<String, String> ret = new HashMap<String, String>();
                for (XmlTag subTag : taglibTags) {
                    XmlTag uriTag = subTag.findFirstSubTag("taglib-uri");
                    if (uriTag == null) continue;
                    XmlTag locationTag = subTag.findFirstSubTag("taglib-location");
                    if (locationTag != null) {
                        ret.put(uriTag.getValue().getTrimmedText(), locationTag.getValue().getTrimmedText());
                        continue;
                    }
                    ret.put(uriTag.getValue().getTrimmedText(), uriTag.getValue().getTrimmedText());
                }
                return new CachedValueProvider.Result(ret, new Object[]{webXmlRootTag});
            }, false);
        }
        return (Map)this.myTaglibUriToResource.getValue();
    }

    @Nullable
    private XmlTag getWebXmlRootTag() {
        ConfigFile deploymentDescriptor = this.getWebXmlDescriptor();
        if (deploymentDescriptor == null) {
            return null;
        }
        XmlFile xmlFile = deploymentDescriptor.getXmlFile();
        if (xmlFile == null) {
            return null;
        }
        XmlDocument doc = xmlFile.getDocument();
        return doc != null ? doc.getRootTag() : null;
    }

    public void initFacet() {
        if (this.myWebSourceRootsNotSpecified) {
            String[] sourceRoots = ModuleRootManager.getInstance((Module)this.getModule()).getSourceRootUrls(false);
            this.getWebConfiguration().setSourceRoots(Arrays.asList(sourceRoots));
        }
        this.myCommonPart.initFacet();
    }

    public void addWebSourceRoot(@NotNull String url) {
        if (url == null) {
            WebFacetImpl.$$$reportNull$$$0(12);
        }
        String[] sourceRoots = ModuleRootManager.getInstance((Module)this.getModule()).getSourceRootUrls();
        LOG.assertTrue(Arrays.asList(sourceRoots).contains(url), (Object)("'" + url + "' is not a source root"));
        List<String> urls = this.getWebConfiguration().getSourceRoots();
        LOG.assertTrue(!urls.contains(url), (Object)("'" + url + "' is already registered"));
        urls.add(url);
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public void removeWebSourceRoot(@NotNull String url) {
        if (url == null) {
            WebFacetImpl.$$$reportNull$$$0(13);
        }
        List<String> sourceRoots = this.getWebConfiguration().getSourceRoots();
        boolean removed = sourceRoots.remove(url);
        LOG.assertTrue(removed, (Object)("Web source root '" + url + "' not found."));
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public List<String> getWebSourceRootUrls() {
        return Collections.unmodifiableList(this.getWebConfiguration().getSourceRoots());
    }

    public void setWebSourceRoots(String @NotNull [] urls) {
        if (urls == null) {
            WebFacetImpl.$$$reportNull$$$0(14);
        }
        this.getWebConfiguration().setSourceRoots(Arrays.asList(urls));
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public ConfigFile getWebXmlDescriptor() {
        return this.getDescriptorsContainer().getConfigFile(DeploymentDescriptorsConstants.WEB_XML_META_DATA);
    }

    private void refreshModel() {
        this.myTaglibUriToResource = null;
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        Collection roots = this.myCommonPart.getDescriptors();
        roots.addAll(this.getSourceRoots());
        for (WebRoot webRoot2 : this.getWebRoots()) {
            VirtualFile file = webRoot2.getFile();
            if (file == null) continue;
            roots.add(file);
        }
        Collection collection = roots;
        if (collection == null) {
            WebFacetImpl.$$$reportNull$$$0(15);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webRoots";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryUrl";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/facet/WebFacetImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/facet/WebFacetImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebAppVersion";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setWebRoots";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addWebRoot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addWebRootNoFire";
                break;
            }
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addWebSourceRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeWebSourceRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setWebSourceRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

