/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.facet;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.facet.JavaeeFrameworkSupportProvider;
import com.intellij.javaee.model.xml.WebAppVersion;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetImpl;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebFacetFrameworkSupportProvider
extends JavaeeFrameworkSupportProvider<WebFacet> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.web.facet.WebFacetFrameworkSupportProvider");
    private boolean myCreateWebXml;

    public WebFacetFrameworkSupportProvider() {
        super((JavaeeFacetType)WebFacetType.getInstance(), DeploymentDescriptorsConstants.WEB_XML_META_DATA, "/web");
    }

    public String getGroupId() {
        return "web";
    }

    protected void setupConfiguration(WebFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        super.setupConfiguration((JavaeeFacet)facet, rootModel, version);
        @NonNls String webDirUrl = rootModel.getContentRootUrls()[0] + "/web";
        facet.addWebRoot(webDirUrl, "/");
        WebFacetImpl webFacet = (WebFacetImpl)facet;
        webFacet.getWebConfiguration().setSourceRoots(Arrays.asList(rootModel.getSourceRootUrls(false)));
    }

    protected JavaeeArtifactTypeBase getExplodedArtifactType() {
        return ExplodedWarArtifactType.getInstance();
    }

    protected void createFiles(WebFacet facet, JavaeeFrameworkSupportInfoCollector collector) {
        List webRoots = facet.getWebRoots();
        if (webRoots.isEmpty()) {
            return;
        }
        String webRootUrl = ((WebRoot)webRoots.get(0)).getDirectoryUrl();
        try {
            File ioFile = new File(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)webRootUrl)), "index.jsp");
            if (ioFile.exists()) {
                return;
            }
            FileUtil.createIfDoesntExist((File)ioFile);
            VirtualFile indexFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            Project project = facet.getModule().getProject();
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("Jsp File.jsp");
            assert (indexFile != null);
            VfsUtil.saveText((VirtualFile)indexFile, (String)fileTemplate.getText(FileTemplateManager.getInstance((Project)project).getDefaultProperties()));
            collector.setIndexJsp(indexFile);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public void processAddedLibraries(Module module, List<Library> addedLibraries) {
        WebFacet webFacet = (WebFacet)ContainerUtil.getFirstItem((Collection)WebFacet.getInstances((Module)module), null);
        if (webFacet != null) {
            Collection artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, (ArtifactType)ExplodedWarArtifactType.getInstance());
            for (Artifact artifact : artifacts) {
                for (Library library : addedLibraries) {
                    if (JavaeeArtifactTypeBase.isStandardJavaeeLibrary((Library)library)) continue;
                    WebArtifactUtil.getInstance().addLibrary(library, artifact, module.getProject());
                }
            }
        }
    }

    public String getTitle() {
        return WebBundle.message("framework.title.web.application", new Object[0]);
    }

    protected ConfigFileVersion getVersionToCreate(String versionString) {
        return WebAppVersion.WebAppVersion_3_0.getValue().equals(versionString) && !this.myCreateWebXml ? null : super.getVersionToCreate(versionString);
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            WebFacetFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        return new WebFrameworkSupportConfigurable(model);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/javaee/web/facet/WebFacetFrameworkSupportProvider", "createConfigurable"));
    }

    private class WebFrameworkSupportConfigurable
    extends JavaeeFrameworkSupportProvider.JavaeeFrameworkSupportConfigurable {
        private final JPanel myPanel;
        private final JCheckBox myCreateWebXmlBox;

        WebFrameworkSupportConfigurable(FrameworkSupportModel model) {
            super((JavaeeFrameworkSupportProvider)WebFacetFrameworkSupportProvider.this, (FrameworkSupportProviderBase)WebFacetFrameworkSupportProvider.this, model, WebFacetFrameworkSupportProvider.this.getVersions(), WebFacetFrameworkSupportProvider.this.getVersionLabelText());
            this.myPanel = new JPanel(new BorderLayout(5, 5));
            this.myCreateWebXmlBox = new JCheckBox(J2EEBundle.message((String)"web.facet.create.web.xml", (Object[])new Object[0]));
            this.myCreateWebXmlBox.setSelected(true);
            this.myPanel.add((Component)super.getComponent(), "West");
            this.myPanel.add((Component)this.myCreateWebXmlBox, "Center");
            this.myCreateWebXmlBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebFacetFrameworkSupportProvider.this.myCreateWebXml = WebFrameworkSupportConfigurable.this.myCreateWebXmlBox.isSelected();
                }
            });
        }

        private void updateCheckBox() {
            FrameworkVersion version = this.getSelectedVersion();
            boolean is3_0 = version != null && WebAppVersion.WebAppVersion_3_0.getValue().equals(version.getVersionName());
            this.myCreateWebXmlBox.setSelected(!is3_0 || WebFacetFrameworkSupportProvider.this.myCreateWebXml);
            this.myCreateWebXmlBox.setVisible(is3_0);
        }

        public JComponent getComponent() {
            this.updateCheckBox();
            return this.myPanel;
        }

        protected void fireFrameworkVersionChanged() {
            super.fireFrameworkVersionChanged();
            this.updateCheckBox();
        }
    }
}

