/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.artifact;

import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesElementType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesPackagingElement;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.artifact.WebFacetContextEvaluationService;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebFacetContextEvaluationServiceImpl
extends WebFacetContextEvaluationService {
    private static final Key<CachedValue<List<IncludedFacetWithPath>>> INCLUDED_WEB_FACETS_KEY = Key.create((String)"WEB_FACETS_INCLUDED_IN_ARTIFACT");
    private static final Key<CachedValue<List<PrefixedVirtualFile>>> WEB_FACET_OUTPUT_FILES_KEY = Key.create((String)"WEB_FACET_OUTPUT_FILES");
    private final Project myProject;

    public WebFacetContextEvaluationServiceImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    private List<IncludedFacetWithPath> getIncludedFacets(@NotNull Artifact artifact) {
        CachedValue cachedValue;
        if (artifact == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(0);
        }
        if ((cachedValue = (CachedValue)artifact.getUserData(INCLUDED_WEB_FACETS_KEY)) == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create(this.computeIncludedFacets(artifact), (Object[])new Object[]{ArtifactManager.getInstance((Project)this.myProject).getModificationTracker(), JavaeeUtil.getAllJavaeeFacetModificationTracker((Project)this.myProject)}), false);
            artifact.putUserData(INCLUDED_WEB_FACETS_KEY, (Object)cachedValue);
        }
        List list = (List)cachedValue.getValue();
        if (list == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private List<IncludedFacetWithPath> computeIncludedFacets(@NotNull Artifact artifact) {
        if (artifact == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(2);
        }
        SmartList result = new SmartList();
        final PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)this.myProject).getResolvingContext();
        WebArtifactUtil webArtifactUtil = WebArtifactUtil.getInstance();
        PackagingElementProcessor<JavaeeFacetResourcesPackagingElement> processor = new PackagingElementProcessor<JavaeeFacetResourcesPackagingElement>((List)result, artifact, webArtifactUtil){
            final /* synthetic */ List val$result;
            final /* synthetic */ Artifact val$artifact;
            final /* synthetic */ WebArtifactUtil val$webArtifactUtil;
            {
                this.val$result = list;
                this.val$artifact = artifact;
                this.val$webArtifactUtil = webArtifactUtil;
            }

            public boolean process(@NotNull JavaeeFacetResourcesPackagingElement element, @NotNull PackagingElementPath path) {
                JavaeeFacet facet;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((facet = element.findFacet(context)) instanceof WebFacet) {
                    this.val$result.add(new IncludedFacetWithPath((WebFacet)facet, WebFacetContextEvaluationServiceImpl.normalizeRelativePath(path.getPathStringFrom("/", this.val$artifact.getRootElement()))));
                }
                return true;
            }

            public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                Artifact included;
                if (element instanceof ArtifactPackagingElement && (included = ((ArtifactPackagingElement)element).findArtifact(context)) != null && !this.val$webArtifactUtil.isWebApplication(included.getArtifactType())) {
                    return false;
                }
                return super.shouldProcessSubstitution(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), (PackagingElementProcessor)processor, (PackagingElementResolvingContext)context, (boolean)true);
        SmartList smartList = result;
        if (smartList == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    private List<PrefixedVirtualFile> getOutputFiles(@NotNull WebFacet webFacet) {
        CachedValue cachedValue;
        if (webFacet == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(4);
        }
        if ((cachedValue = (CachedValue)webFacet.getUserData(WEB_FACET_OUTPUT_FILES_KEY)) == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> {
                List<PrefixedVirtualFile> files = this.computeOutputFiles(webFacet);
                List dependencies = ((StreamEx)StreamEx.of(files).map(PrefixedVirtualFile::getFile).distinct()).append(new Object[]{ProjectRootManager.getInstance((Project)this.myProject), ArtifactManager.getInstance((Project)this.myProject).getModificationTracker(), JavaeeUtil.getAllJavaeeFacetModificationTracker((Project)this.myProject)}).toList();
                return CachedValueProvider.Result.create(files, (Collection)dependencies);
            }, false);
            webFacet.putUserData(WEB_FACET_OUTPUT_FILES_KEY, (Object)cachedValue);
        }
        return (List)cachedValue.getValue();
    }

    private List<PrefixedVirtualFile> computeOutputFiles(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(5);
        }
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)this.myProject).getResolvingContext();
        Collection webArtifactTypes = WebArtifactUtil.getInstance().getWebArtifactTypes();
        Collection artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, context, webArtifactTypes, false);
        ArrayList<PrefixedVirtualFile> result = new ArrayList<PrefixedVirtualFile>();
        for (Artifact artifact : artifacts) {
            for (IncludedFacetWithPath includedFacet : this.getIncludedFacets(artifact)) {
                WebFacetContextEvaluationServiceImpl.collectWebRoots(includedFacet, result);
            }
        }
        if (artifacts.isEmpty()) {
            WebFacetContextEvaluationServiceImpl.collectWebRoots(new IncludedFacetWithPath(webFacet, ""), result);
        }
        return result;
    }

    private static void collectWebRoots(IncludedFacetWithPath includedFacet, List<PrefixedVirtualFile> result) {
        for (WebRoot root : includedFacet.getWebFacet().getWebRoots()) {
            VirtualFile file = root.getFile();
            if (file == null) continue;
            String prefix = includedFacet.getPathInArtifact() + WebFacetContextEvaluationServiceImpl.normalizeRelativePath(root.getURI());
            result.add(new PrefixedVirtualFile(file, prefix));
        }
    }

    @Override
    @NotNull
    public List<VirtualFile> getOutputFiles(@NotNull WebFacet webFacet, @NotNull String relativePathInOutput) {
        if (webFacet == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(6);
        }
        if (relativePathInOutput == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(7);
        }
        List<PrefixedVirtualFile> files = this.getOutputFiles(webFacet);
        relativePathInOutput = WebFacetContextEvaluationServiceImpl.normalizeRelativePath(relativePathInOutput);
        SmartList result = new SmartList();
        for (PrefixedVirtualFile prefixedFile : files) {
            String relativePath = WebFacetContextEvaluationServiceImpl.getRelativePathIfStartsWith(relativePathInOutput, prefixedFile.getPrefixPath());
            if (relativePath == null) continue;
            VirtualFile file = prefixedFile.getFile().findFileByRelativePath(UriUtil.trimTrailingSlashes((String)relativePath));
            ContainerUtil.addIfNotNull((Collection)result, (Object)file);
        }
        SmartList smartList = result;
        if (smartList == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    @Override
    public boolean processChildren(@NotNull WebFacet webFacet, @NotNull String relativePathInOutput, @NotNull WebDirectoryElement.WebDirectoryProcessor processor) throws Exception {
        if (webFacet == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(9);
        }
        if (relativePathInOutput == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(11);
        }
        relativePathInOutput = WebFacetContextEvaluationServiceImpl.normalizeRelativePath(relativePathInOutput);
        List<PrefixedVirtualFile> files = this.getOutputFiles(webFacet);
        for (PrefixedVirtualFile prefixedFile : files) {
            String name;
            String prefixTail;
            int i;
            String prefixPath = prefixedFile.getPrefixPath();
            String relativePath = WebFacetContextEvaluationServiceImpl.getRelativePathIfStartsWith(relativePathInOutput, prefixPath);
            if (relativePath != null) {
                VirtualFile file = prefixedFile.getFile().findFileByRelativePath(UriUtil.trimTrailingSlashes((String)relativePath));
                if (file == null) continue;
                for (VirtualFile child : file.getChildren()) {
                    if (!child.isValid() || processor.execute(child.getName(), child.isDirectory())) continue;
                    return false;
                }
                continue;
            }
            if (!prefixPath.startsWith(relativePathInOutput) || (i = (prefixTail = prefixPath.substring(relativePathInOutput.length())).indexOf(47)) == -1 || processor.execute(name = prefixTail.substring(0, i), true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getRelativeOutputPathForFile(@NotNull WebFacet webFacet, @NotNull VirtualFile file) {
        if (webFacet == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(12);
        }
        if (file == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(13);
        }
        List<PrefixedVirtualFile> files = this.getOutputFiles(webFacet);
        for (PrefixedVirtualFile prefixedFile : files) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)prefixedFile.getFile(), (char)'/');
            if (relativePath == null) continue;
            return UriUtil.trimTrailingSlashes((String)(prefixedFile.getPrefixPath() + WebFacetContextEvaluationServiceImpl.normalizeRelativePath(relativePath)));
        }
        return null;
    }

    @Nullable
    private static String getRelativePathIfStartsWith(@NotNull String path, @NotNull String basePath) {
        if (path == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(14);
        }
        if (basePath == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(15);
        }
        if (!path.startsWith(basePath)) {
            return null;
        }
        return path.substring(basePath.length());
    }

    private static String normalizeRelativePath(@NotNull String path) {
        if (path == null) {
            WebFacetContextEvaluationServiceImpl.$$$reportNull$$$0(16);
        }
        if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
            path = ((String)path).substring(1);
        }
        if (((String)path).length() > 0 && ((String)path).charAt(((String)path).length() - 1) != '/') {
            path = (String)path + "/";
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePathInOutput";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedFacets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeIncludedFacets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedFacets";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeIncludedFacets";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeOutputFiles";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeOutputPathForFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathIfStartsWith";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalizeRelativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PrefixedVirtualFile {
        private final VirtualFile myFile;
        private final String myPrefixPath;

        private PrefixedVirtualFile(@NotNull VirtualFile file, @NotNull String prefixPath) {
            if (file == null) {
                PrefixedVirtualFile.$$$reportNull$$$0(0);
            }
            if (prefixPath == null) {
                PrefixedVirtualFile.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.myPrefixPath = prefixPath;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public String getPrefixPath() {
            return this.myPrefixPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prefixPath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl$PrefixedVirtualFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class IncludedFacetWithPath {
        private final WebFacet myWebFacet;
        private final String myPathInArtifact;

        private IncludedFacetWithPath(@NotNull WebFacet webFacet, @NotNull String pathInArtifact) {
            if (webFacet == null) {
                IncludedFacetWithPath.$$$reportNull$$$0(0);
            }
            if (pathInArtifact == null) {
                IncludedFacetWithPath.$$$reportNull$$$0(1);
            }
            this.myWebFacet = webFacet;
            this.myPathInArtifact = pathInArtifact;
        }

        public WebFacet getWebFacet() {
            return this.myWebFacet;
        }

        public String getPathInArtifact() {
            return this.myPathInArtifact;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "webFacet";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pathInArtifact";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl$IncludedFacetWithPath";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

