/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.artifact;

import com.intellij.javaee.appServers.context.DefaultWebModuleContextProvider;
import com.intellij.javaee.appServers.context.WebModuleContextProvider;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesElementType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesPackagingElement;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.javaee.web.WebFacetContextProvider;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Ref;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebArtifactUtilImpl
extends WebArtifactUtil {
    public boolean isWebApplication(@NotNull ArtifactType artifactType) {
        if (artifactType == null) {
            WebArtifactUtilImpl.$$$reportNull$$$0(0);
        }
        return artifactType.equals(ExplodedWarArtifactType.getInstance()) || artifactType.equals(WarArtifactType.getInstance());
    }

    public ArtifactType getExplodedWarArtifactType() {
        return ExplodedWarArtifactType.getInstance();
    }

    public ArtifactType getWarArtifactType() {
        return WarArtifactType.getInstance();
    }

    public Collection<? extends Artifact> getWebArtifacts(@NotNull Project project) {
        if (project == null) {
            WebArtifactUtilImpl.$$$reportNull$$$0(1);
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            if (!this.isWebApplication(artifact.getArtifactType())) continue;
            result.add(artifact);
        }
        return result;
    }

    public void addLibrary(@NotNull Library library, @NotNull Artifact artifact, @NotNull Project project) {
        if (library == null) {
            WebArtifactUtilImpl.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            WebArtifactUtilImpl.$$$reportNull$$$0(3);
        }
        if (project == null) {
            WebArtifactUtilImpl.$$$reportNull$$$0(4);
        }
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
        List elements = PackagingElementFactory.getInstance().createLibraryElements(library);
        for (PackagingElement element : elements) {
            String dir = element.getFilesKind(artifactManager.getResolvingContext()).containsDirectoriesWithClasses() ? "classes" : "lib";
            artifactManager.addElementsToDirectory(artifact, "WEB-INF/" + dir, element);
        }
    }

    public Collection<? extends ArtifactType> getWebArtifactTypes() {
        ArrayList<ArtifactType> list = new ArrayList<ArtifactType>();
        list.add(this.getExplodedWarArtifactType());
        list.add(this.getWarArtifactType());
        return list;
    }

    @Nullable
    public String getContextRoot(@NotNull Artifact earArtifact, @NotNull WebFacet webFacet) {
        if (earArtifact == null) {
            WebArtifactUtilImpl.$$$reportNull$$$0(5);
        }
        if (webFacet == null) {
            WebArtifactUtilImpl.$$$reportNull$$$0(6);
        }
        return WebFacetContextProvider.getModuleContext((WebModuleContextProvider)DefaultWebModuleContextProvider.INSTANCE, (Artifact)earArtifact, (WebFacet)webFacet);
    }

    public String getModuleWebUri(@NotNull Artifact earArtifact, final @NotNull WebFacet webFacet) {
        if (earArtifact == null) {
            WebArtifactUtilImpl.$$$reportNull$$$0(7);
        }
        if (webFacet == null) {
            WebArtifactUtilImpl.$$$reportNull$$$0(8);
        }
        Project project = webFacet.getModule().getProject();
        final Ref parentElementNameRef = Ref.create(null);
        final PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        PackagingElementProcessor<JavaeeFacetResourcesPackagingElement> processor = new PackagingElementProcessor<JavaeeFacetResourcesPackagingElement>(){

            public boolean process(@NotNull JavaeeFacetResourcesPackagingElement element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                CompositePackagingElement parent = path.getLastParent();
                if (webFacet.equals((Object)element.findFacet(context)) && parent != null) {
                    parentElementNameRef.set((Object)parent.getName());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javaee/web/artifact/WebArtifactUtilImpl$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ArtifactUtil.processPackagingElements((Artifact)earArtifact, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), (PackagingElementProcessor)processor, (PackagingElementResolvingContext)context, (boolean)true);
        return (String)parentElementNameRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "earArtifact";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/web/artifact/WebArtifactUtilImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isWebApplication";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getWebArtifacts";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibrary";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextRoot";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleWebUri";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

