/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class WebTemplateFileProcessor
extends ProjectTemplateFileProcessor {
    @Nullable
    protected String encodeFileText(String content, VirtualFile file, Project project) throws IOException {
        return (String)ReadAction.compute(() -> {
            DomFileElement element;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile instanceof XmlFile && (element = DomManager.getDomManager((Project)project).getFileElement((XmlFile)psiFile, WebApp.class)) != null) {
                String value;
                XmlAttribute attribute;
                String text = psiFile.getText();
                XmlAttributeValue version = ((WebApp)element.getRootElement()).getVersion().getXmlAttributeValue();
                if (version != null) {
                    text = version.getValueTextRange().replace(text, WebTemplateFileProcessor.wrap((String)"WEB_XML_VERSION"));
                }
                if ((attribute = ((WebApp)element.getRootElement()).getXmlTag().getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance")) != null && (value = attribute.getValue()) != null) {
                    String param = value.substring(0, value.length() - "2_4.xsd".length()) + "${WEB_XML_VERSION_FILE}.xsd";
                    text = attribute.getValueTextRange().shiftRight(attribute.getValueElement().getTextRange().getStartOffset()).replace(text, param);
                }
                return text;
            }
            return null;
        });
    }
}

