/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.module.view.nodes.DirectoryNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeFacetNodeDescriptor;
import com.intellij.javaee.module.view.web.WebRootDeleteProvider;
import com.intellij.javaee.module.view.web.nodes.WebFacetNodeDescriptor;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.psi.PsiDirectory;
import java.util.List;
import javax.swing.Icon;

public class WebRootNodeDescriptor
extends DirectoryNodeDescriptor {
    private final WebRoot myWebRoot;

    public WebRootNodeDescriptor(WebRoot webRoot2, PsiDirectory directory, JavaeeFacetNodeDescriptor parentDescriptor, Object parameters) {
        super(directory, (NodeDescriptor)parentDescriptor, parameters);
        this.myWebRoot = webRoot2;
    }

    public PsiDirectory updateElement() {
        return !((PsiDirectory)this.getJamElement()).isValid() ? null : (PsiDirectory)this.getJamElement();
    }

    @Override
    public String getNewTooltip() {
        return ((PsiDirectory)this.getJamElement()).isValid() ? J2EEBundle.message((String)"tooltip.text.web.resource.directory", (Object[])new Object[]{this.myWebRoot.getPresentableUrl()}) : null;
    }

    public int getWeight() {
        List allWebRoots = this.getWebFacet().getWebRoots();
        int index = allWebRoots.indexOf(this.myWebRoot);
        return 50 + index % 50;
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        WebFacet webFacet = this.getWebFacet();
        return new WebRootDeleteProvider(this.myProject, this.myWebRoot, webFacet, null);
    }

    private WebFacet getWebFacet() {
        return (WebFacet)((WebFacetNodeDescriptor)this.getParentDescriptor()).getFacet();
    }

    public String getComment() {
        return "(" + this.myWebRoot.getURI() + ")";
    }

    @Override
    public Icon getNewIcon() {
        return AllIcons.Nodes.WebFolder;
    }
}

