/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.CommonListener;
import com.intellij.javaee.module.view.common.editor.FacetAsVirtualFileImpl;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.module.view.nodes.JavaeeDeploymentDescriptorNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeFacetNodeDescriptor;
import com.intellij.javaee.module.view.web.nodes.FilterNodeDescriptor;
import com.intellij.javaee.module.view.web.nodes.ListenerNodeDescriptor;
import com.intellij.javaee.module.view.web.nodes.ServletNodeDescriptor;
import com.intellij.javaee.module.view.web.nodes.WebFragmentDescriptor;
import com.intellij.javaee.module.view.web.nodes.WebRootNodeDescriptor;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.descriptors.ConfigFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebFacetNodeDescriptor
extends JavaeeFacetNodeDescriptor<WebFacet> {
    public WebFacetNodeDescriptor(WebFacet facet, NodeDescriptor parentDescriptor, Object parameters) {
        super((JavaeeFacet)facet, parentDescriptor, parameters);
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            WebFacetNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (CommonDataKeys.NAVIGATABLE.getName().equals(dataId)) {
            if (((WebFacet)this.getFacet()).getRoot() == null) {
                return null;
            }
            FacetAsVirtualFileImpl file = this.getVirtualFile();
            if (file == null || !file.isValid()) {
                return null;
            }
            return new OpenFileDescriptor(this.myProject, (VirtualFile)file);
        }
        return super.getData(dataId);
    }

    public SimpleNode @NotNull [] getChildren() {
        WebFacet webFacet = (WebFacet)this.getFacet();
        if (webFacet.isDisposed()) {
            if (EMPTY_ARRAY == null) {
                WebFacetNodeDescriptor.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<SimpleNode> result = new ArrayList<SimpleNode>();
        this.addWebModuleStructureNodes(result);
        List directories = webFacet.getResources();
        for (PsiDirectory directory : directories) {
            Module module;
            try {
                VirtualFile jarFile = JarFileSystem.getInstance().getVirtualFileForJar(directory.getVirtualFile());
                if (jarFile != null) {
                    result.add(new WebFragmentDescriptor(directory.getParent(), jarFile, (NodeDescriptor)this, this.getParameters()));
                    continue;
                }
            }
            catch (Throwable jarFile) {
                // empty catch block
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory)) == null) continue;
            result.add(new WebFragmentDescriptor(directory.getParent(), module, (NodeDescriptor)this, this.getParameters()));
        }
        SimpleNode[] simpleNodeArray = result.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            WebFacetNodeDescriptor.$$$reportNull$$$0(2);
        }
        return simpleNodeArray;
    }

    private void addWebModuleStructureNodes(List<SimpleNode> result) {
        ConfigFile[] deploymentDescriptors;
        J2EEModuleParameters parameters = (J2EEModuleParameters)this.getParameters();
        if (!parameters.showMembers()) {
            return;
        }
        WebFacet webFacet = (WebFacet)this.getFacet();
        List webRoots = webFacet.getWebRoots();
        for (ConfigFile[] webRoot2 : webRoots) {
            VirtualFile webRootDir = webRoot2.getFile();
            PsiDirectory directory = webRootDir != null && webRootDir.isValid() ? PsiManager.getInstance((Project)this.myProject).findDirectory(webRootDir) : null;
            if (directory == null) continue;
            result.add((SimpleNode)new WebRootNodeDescriptor((WebRoot)webRoot2, directory, this, parameters));
        }
        for (ConfigFile descriptor : deploymentDescriptors = webFacet.getDescriptorsContainer().getConfigFiles()) {
            if (!descriptor.isValid()) continue;
            result.add((SimpleNode)new JavaeeDeploymentDescriptorNodeDescriptor(descriptor, (NodeDescriptor)this, (Object)parameters));
        }
        WebModel webModel = webFacet.getWebModel();
        for (CommonServlet servlet : webModel.getServlets()) {
            result.add((SimpleNode)new ServletNodeDescriptor(servlet, (NodeDescriptor)this, parameters));
        }
        for (CommonFilter filter : webModel.getFilters()) {
            result.add((SimpleNode)new FilterNodeDescriptor(filter, (NodeDescriptor)this, parameters));
        }
        for (CommonListener listener : webModel.getListeners()) {
            result.add((SimpleNode)new ListenerNodeDescriptor(listener, (NodeDescriptor)this, parameters));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/module/view/web/nodes/WebFacetNodeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/module/view/web/nodes/WebFacetNodeDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

