/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeModuleUtil;
import com.intellij.javaee.module.view.web.EditWebRootDialog;
import com.intellij.javaee.ui.TableWithCRUDButtons;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetImpl;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.TableUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class WebFacetWebRootsPanel
extends TableWithCRUDButtons {
    private final WebFacetImpl myWebFacet;
    private List<WebRootData> myWebRoots;
    private AbstractTableModel myTableModel;
    private final Set<WebRootData> myRootsWithDuplicatedRelativePath = new HashSet<WebRootData>();
    private final Module myModule;
    private final boolean myHighlightInvalidRoots;

    public WebFacetWebRootsPanel(Module module, WebFacetImpl webFacet, boolean highlightInvalidRoots) {
        super(module.getProject(), true, true);
        this.myHighlightInvalidRoots = highlightInvalidRoots;
        this.myModule = module;
        this.myTable.getSelectionModel().setSelectionMode(2);
        this.myWebFacet = webFacet;
        this.setupControls();
        this.refreshModel();
        this.myTable.setModel(this.myTableModel);
    }

    private void setupControls() {
        this.myTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return WebFacetWebRootsPanel.this.myWebRoots.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return J2EEBundle.message((String)"column.name.edit.web.roots.web.resource.directory", (Object[])new Object[0]);
                    }
                    case 1: {
                        return J2EEBundle.message((String)"column.name.edit.web.roots..relative.to.deployment.root", (Object[])new Object[0]);
                    }
                }
                return "???";
            }

            public Class getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return WebRootData.class;
                    }
                    case 1: {
                        return String.class;
                    }
                }
                return null;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                WebRootData webRoot2 = WebFacetWebRootsPanel.this.myWebRoots.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return webRoot2;
                    }
                    case 1: {
                        return webRoot2.getRelativePath();
                    }
                }
                return "???";
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                WebRootData webRoot2 = WebFacetWebRootsPanel.this.myWebRoots.get(row);
                switch (column) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        WebRootData newWebRoot = new WebRootData(webRoot2.getUrl(), (String)value);
                        WebFacetWebRootsPanel.this.myWebRoots.set(row, newWebRoot);
                        WebFacetWebRootsPanel.this.updateHighlighting();
                        break;
                    }
                }
            }
        };
        this.myTable.setDefaultRenderer(WebRootData.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null) {
                    WebRootData webRoot2 = (WebRootData)value;
                    this.setIcon(AllIcons.Nodes.WebFolder);
                    String file = PathUtil.toPresentableUrl((String)webRoot2.getUrl());
                    String text = FileUtil.toSystemDependentName((String)file);
                    this.setText(text);
                    if (WebFacetWebRootsPanel.this.myHighlightInvalidRoots && webRoot2.findFile() == null) {
                        this.setForeground(WebFacetWebRootsPanel.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getEffectColor());
                    } else {
                        WebFacetWebRootsPanel.setNormalForeground(this, isSelected);
                    }
                }
                return this;
            }
        });
        this.myTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                WebRootData webRoot2 = WebFacetWebRootsPanel.this.myWebRoots.get(row);
                this.setBackground(isSelected ? UIUtil.getTableSelectionBackground((boolean)true) : UIUtil.getTableBackground());
                WebFacetWebRootsPanel.setNormalForeground(this, isSelected);
                this.setToolTipText(null);
                if (webRoot2.getRelativePath().startsWith("..")) {
                    this.setForeground(WebFacetWebRootsPanel.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getEffectColor());
                    this.setToolTipText(J2EEBundle.message((String)"output.path.must.point.to.directory.under.output.root", (Object[])new Object[0]));
                } else if (WebFacetWebRootsPanel.this.myRootsWithDuplicatedRelativePath.contains(webRoot2)) {
                    this.setBackground(WebFacetWebRootsPanel.getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES).getBackgroundColor());
                    this.setToolTipText(J2EEBundle.message((String)"warning.duplicate.relative.deployment.path.text", (Object[])new Object[]{webRoot2.getRelativePath()}));
                }
                return this;
            }
        });
        this.myTable.setRowHeight(AllIcons.Nodes.WebFolder.getIconHeight());
    }

    private static void setNormalForeground(DefaultTableCellRenderer renderer, boolean isSelected) {
        renderer.setForeground(isSelected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground());
    }

    private static TextAttributes getAttributes(TextAttributesKey attributes) {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributes);
    }

    protected void doNew() {
        TableUtil.stopEditing((JTable)this.myTable);
        String directory = JavaeeModuleUtil.getModuleDirectoryPath((Module)this.myModule);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(directory);
        WebRootData webRoot2 = new WebRootData(file.getUrl(), "/");
        EditWebRootDialog dialog = new EditWebRootDialog(this.myProject, webRoot2, true, this.myModule, this.myWebRoots);
        if (!dialog.showAndGet()) {
            return;
        }
        webRoot2 = dialog.saveWebRoot();
        if (webRoot2 == null) {
            return;
        }
        if (!this.myWebRoots.contains(webRoot2)) {
            this.myWebRoots.add(webRoot2);
            this.myTableModel.fireTableDataChanged();
            this.updateHighlighting();
        }
    }

    protected void doEdit() {
        TableUtil.stopEditing((JTable)this.myTable);
        List<WebRootData> webRoots = this.getSelectedWebRoots();
        if (webRoots.size() != 1) {
            return;
        }
        WebRootData webRootToEdit = webRoots.get(0);
        ArrayList<WebRootData> existingWebRoots = new ArrayList<WebRootData>(this.myWebRoots);
        existingWebRoots.remove(webRootToEdit);
        int index = this.myWebRoots.indexOf(webRootToEdit);
        EditWebRootDialog dialog = new EditWebRootDialog(this.myProject, webRootToEdit, true, this.myModule, existingWebRoots);
        if (!dialog.showAndGet()) {
            return;
        }
        WebRootData webRoot2 = dialog.saveWebRoot();
        if (webRoot2 == null) {
            return;
        }
        this.myTableModel.fireTableDataChanged();
        this.myWebRoots.set(index, webRoot2);
        this.updateHighlighting();
    }

    protected boolean isRemoveOk() {
        String message;
        List<WebRootData> webRoots = this.getSelectedWebRoots();
        if (webRoots.isEmpty()) {
            return false;
        }
        if (webRoots.size() == 1) {
            String path = FileUtil.toSystemDependentName((String)PathUtil.toPresentableUrl((String)webRoots.get(0).getUrl()));
            message = J2EEBundle.message((String)"message.text.remove.web.resource.directory", (Object[])new Object[]{path});
        } else {
            message = J2EEBundle.message((String)"message.text.remove.selected.web.resource.directories", (Object[])new Object[0]);
        }
        return Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)J2EEBundle.message((String)"message.title.remove.web.resource.directory", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    protected void doRemove() {
        this.myWebRoots.removeAll(this.getSelectedWebRoots());
        this.myTableModel.fireTableDataChanged();
        this.updateHighlighting();
    }

    private List<WebRootData> getSelectedWebRoots() {
        int[] rows = this.myTable.getSelectedRows();
        ArrayList<WebRootData> webRoots = new ArrayList<WebRootData>();
        for (int row : rows) {
            webRoots.add((WebRootData)this.myTable.getModel().getValueAt(row, 0));
        }
        return webRoots;
    }

    protected void refreshModelImpl() {
        this.myWebRoots = new ArrayList<WebRootData>();
        if (this.myWebFacet != null) {
            this.myWebRoots.addAll(this.myWebFacet.getWebConfiguration().getWebRoots());
        }
        this.updateHighlighting();
        this.myTableModel.fireTableDataChanged();
    }

    public void dispose() {
        TableUtil.stopEditing((JTable)this.myTable);
    }

    private void updateHighlighting() {
        HashMap<String, WebRootData> paths = new HashMap<String, WebRootData>();
        this.myRootsWithDuplicatedRelativePath.clear();
        for (WebRootData webRoot2 : this.myWebRoots) {
            WebRootData old = paths.put(webRoot2.getRelativePath(), webRoot2);
            if (old == null) continue;
            this.myRootsWithDuplicatedRelativePath.add(webRoot2);
            this.myRootsWithDuplicatedRelativePath.add(old);
        }
    }

    public void createDirectories() {
        if (this.myWebFacet != null) {
            List<WebRoot> webRoots = this.myWebFacet.getWebRoots();
            for (WebRoot webRoot2 : webRoots) {
                if (webRoot2.getFile() != null) continue;
                this.createDirectory(webRoot2.getDirectoryUrl());
            }
        }
    }

    private void createDirectory(String url) {
        int index = url.lastIndexOf(47);
        String parentUrl = url.substring(0, index);
        String directoryName = url.substring(index + 1);
        VirtualFile parent = VirtualFileManager.getInstance().findFileByUrl(parentUrl);
        if (parent != null) {
            try {
                parent.createChildDirectory((Object)this, directoryName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getHelpID() {
        return "project.creatingModules.resourceWeb";
    }

    public boolean isModified() {
        return !((WebFacetConfiguration)this.myWebFacet.getConfiguration()).getWebRoots().equals(this.myWebRoots);
    }

    public boolean isEditing() {
        return this.myTable.isEditing();
    }

    public void saveData() {
        TableUtil.stopEditing((JTable)this.myTable);
        if (this.myWebFacet != null) {
            this.myWebFacet.setWebRoots(this.myWebRoots);
        }
    }
}

