/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.module.view.PrefixNameSuffixPanel;
import com.intellij.javaee.module.view.common.InheritedClassBrowseButtonListener;
import com.intellij.javaee.ui.JavaeeCodeStyleSettings;
import com.intellij.javaee.ui.NewAbstractDataHolder;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.WebCommonClassNames;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.ui.FieldPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebCreateDialog
extends DialogWrapper {
    private FieldPanel myDefaultPackage;
    private String myOldName = "";
    private FieldPanel myClass;
    private JPanel myPanel;
    private JPanel myNamePanel;
    private JCheckBox myCreateAnnotatedClassCheckBox;
    private final Project myProject;
    private final NewAbstractDataHolder myDataHolder;
    private String myOldDefaultPackage;
    private final PrefixNameSuffixPanel myPrefixNameSuffixPanel;
    private final String myBaseClass;
    private final String myEntityName;
    private final String myHelpTopic;

    public WebCreateDialog(final @Nullable WebApp root, final NewAbstractDataHolder dataHolder, @Nls String title, Project project, String baseClass, String entityName, String helpTopic) {
        super(project, true);
        this.myProject = project;
        this.myDataHolder = dataHolder;
        this.myBaseClass = baseClass;
        this.myEntityName = entityName;
        this.myHelpTopic = helpTopic;
        this.$$$setupUI$$$();
        if (root == null) {
            this.myCreateAnnotatedClassCheckBox.setSelected(true);
            this.myCreateAnnotatedClassCheckBox.setEnabled(false);
        } else {
            boolean available = JavaLibraryUtils.hasLibraryClass((Project)project, (String)WebCommonClassNames.ANNOTATION_WEB_SERVLET.javax()) || JavaLibraryUtils.hasLibraryClass((Project)project, (String)WebCommonClassNames.ANNOTATION_WEB_SERVLET.jakarta());
            this.myCreateAnnotatedClassCheckBox.setSelected(available);
        }
        this.myPrefixNameSuffixPanel = new PrefixNameSuffixPanel(WebBundle.message("prefix.name.suffix.panel.name", new Object[0]), this.myProject){

            @NotNull
            protected String correctRawName(String rawName) {
                String string = rawName;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            protected Collection getExistingElements() {
                return root == null ? Collections.emptyList() : root.getServlets();
            }

            protected String getPrefix(JavaeeCodeStyleSettings settings) {
                return dataHolder.getNamePrefix(settings);
            }

            protected String getSuffix(JavaeeCodeStyleSettings settings) {
                return dataHolder.getNameSuffix(settings);
            }

            public void nameChanged() {
                WebCreateDialog.this.updateNames();
                WebCreateDialog.this.updateOKAction();
            }

            public void codeStyleChanged() {
                WebCreateDialog.this.refreshControls();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/web/WebCreateDialog$1", "correctRawName"));
            }
        };
        this.myNamePanel.setLayout(new BorderLayout());
        this.myNamePanel.add((Component)this.myPrefixNameSuffixPanel.getComponent(), "Center");
        this.myPrefixNameSuffixPanel.setFullNameAndUpdate(dataHolder.getName());
        this.setupControls();
        this.changeControlsType();
        this.refreshControls();
        this.updateNames();
        this.init();
        this.setTitle(title);
    }

    private void changeControlsType() {
        InheritedClassBrowseButtonListener chooser = new InheritedClassBrowseButtonListener(this.myBaseClass, J2EEBundle.message((String)"dialog.title.choose.class", (Object[])new Object[]{this.myEntityName}), this.myProject);
        this.myClass.setBrowseButtonActionListener((ActionListener)chooser);
        this.myClass.createComponent();
        this.myPanel.doLayout();
    }

    private void refreshControls() {
        this.myPrefixNameSuffixPanel.resetPrefixSuffixAndUpdate();
        this.myClass.setText(this.myDataHolder.getClassName());
        this.myDefaultPackage.setText(this.myDataHolder.getPackage());
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpTopic;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPrefixNameSuffixPanel.getPreferredFocusedComponent();
    }

    public JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void setupControls() {
        this.myDefaultPackage.setLabelText(J2EEBundle.message((String)"label.servlet.properties.package", (Object[])new Object[0]));
        this.myDefaultPackage.setBrowseButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageChooserDialog chooser = new PackageChooserDialog(J2EEBundle.message((String)"dialog.title.choose.package", (Object[])new Object[]{WebCreateDialog.this.myEntityName}), WebCreateDialog.this.myProject);
                chooser.selectPackage(WebCreateDialog.this.myDefaultPackage.getText());
                chooser.show();
                PsiPackage aPackage = chooser.getSelectedPackage();
                if (aPackage != null) {
                    WebCreateDialog.this.myDefaultPackage.setText(aPackage.getQualifiedName());
                }
            }
        });
        this.myDefaultPackage.setChangeListener(() -> this.updateNames());
        this.myDefaultPackage.createComponent();
        this.myClass.setLabelText(J2EEBundle.message((String)"label.properties.class", (Object[])new Object[0]));
        this.myClass.setChangeListener(() -> this.updateOKAction());
        this.myClass.createComponent();
    }

    private void updateOKAction() {
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        this.setOKActionEnabled(nameHelper.isQualifiedName(this.getClassName()) && (this.getDefaultPackageName().isEmpty() || nameHelper.isQualifiedName(this.getDefaultPackageName())));
    }

    private void updateNames() {
        this.updateNameField(this.myClass, this.myPrefixNameSuffixPanel.getPrefix(), this.myPrefixNameSuffixPanel.getSuffix());
        this.myOldName = this.myPrefixNameSuffixPanel.getIdentifierCompatibleRawName();
        this.myOldDefaultPackage = this.getDefaultPackageName();
    }

    private void updateNameField(FieldPanel field, String prefix, String suffix) {
        String className;
        String aPackage;
        String text = field.getText();
        if (StringUtil.endsWithChar((CharSequence)text, (char)'.')) {
            text = text.substring(0, text.length() - 1);
        }
        if ((aPackage = CreateClassUtil.extractPackage((String)text)).length() == 0 || aPackage.equals(this.myOldDefaultPackage)) {
            aPackage = this.getDefaultPackageName();
        }
        if ((className = CreateClassUtil.extractClassName((String)text)).length() == 0 || className.equals(prefix + this.myOldName + suffix)) {
            @NlsSafe String fqName = CreateClassUtil.makeFQName((String)aPackage, (String)(prefix + this.myPrefixNameSuffixPanel.getIdentifierCompatibleRawName() + suffix));
            field.setText(fqName);
        }
    }

    @NotNull
    @NlsSafe
    private String getDefaultPackageName() {
        String name = this.myDefaultPackage.getText();
        if (name == null) {
            name = "";
        }
        if (StringUtil.endsWithChar((CharSequence)name, (char)'.')) {
            name = name.substring(0, name.length() - 1);
        }
        String string = name;
        if (string == null) {
            WebCreateDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void doOKAction() {
        if (!this.isDataValid()) {
            return;
        }
        super.doOKAction();
    }

    private String getServletName() {
        return this.myPrefixNameSuffixPanel.getFullName();
    }

    private String getClassName() {
        return this.myClass.getText();
    }

    private void updateServletInfo() {
        this.myDataHolder.setName(this.getServletName());
        this.myDataHolder.setClassName(this.getClassName());
        this.myDataHolder.setPackage(this.getDefaultPackageName());
    }

    private boolean isDataValid() {
        this.updateServletInfo();
        if (!this.myDataHolder.checkNameIsUnique()) {
            String errorString = J2EEBundle.message((String)"message.text.exists", (Object[])new Object[]{this.myEntityName, this.myDataHolder.getName()});
            Messages.showMessageDialog((Project)this.myProject, (String)errorString, (String)J2EEBundle.message((String)"message.title.error", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    public boolean isCreateAnnotatedClass() {
        return this.myCreateAnnotatedClassCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/web/WebCreateDialog", "getDefaultPackageName"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        FieldPanel fieldPanel;
        FieldPanel fieldPanel2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDefaultPackage = fieldPanel2 = new FieldPanel();
        jPanel2.add((Component)fieldPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 6, 0, null, new Dimension(250, -1), null));
        this.myClass = fieldPanel = new FieldPanel();
        jPanel2.add((Component)fieldPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 6, 0, null, new Dimension(250, -1), null));
        this.myNamePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCreateAnnotatedClassCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/WebBundle", WebCreateDialog.class).getString("javaee.web.option.create.java.6.annotated.class"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

