/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.model.xml.web.MimeMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MimeTypeInspection
extends DomElementsInspection<WebApp> {
    @NonNls
    private final Pattern myPattern = Pattern.compile("[^\\p{Cc}^\\s]+/[^\\p{Cc}^\\s]+");

    public MimeTypeInspection() {
        super(WebApp.class, new Class[0]);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = J2EEBundle.message((String)"group.names.javaee.issues", (Object[])new Object[0]);
        if (string == null) {
            MimeTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "MimeType";
    }

    public void checkFileElement(DomFileElement<WebApp> domFileElement, DomElementAnnotationHolder holder) {
        for (MimeMapping mapping : ((WebApp)domFileElement.getRootElement()).getMimeMappings()) {
            GenericDomValue mimeType = mapping.getMimeType();
            String stringValue = mimeType.getStringValue();
            if (stringValue == null || this.myPattern.matcher(stringValue).matches()) continue;
            holder.createProblem((DomElement)mimeType, WebBundle.message("inspection.javaee.web.xml.mime.type.message", stringValue), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/web/highlighting/MimeTypeInspection", "getGroupDisplayName"));
    }
}

