/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.progress;

import com.intellij.docker.agent.progress.DockerResponseItem;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nJ\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cJ\f\u0010\u001d\u001a\u00020\u0010*\u00020\u0019H\u0002J\u0014\u0010\u001e\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0016\u001a\u00020\nH\u0002J\f\u0010\u001f\u001a\u00020\u0010*\u00020\u0019H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/intellij/docker/agent/progress/DockerProgressDetailsFormat;", "", "()V", "hideCounts", "", "getHideCounts", "()Z", "setHideCounts", "(Z)V", "ttyWidth", "", "getTtyWidth", "()I", "setTtyWidth", "(I)V", "units", "", "getUnits", "()Ljava/lang/String;", "setUnits", "(Ljava/lang/String;)V", "getPbBox", "percentage", "toTtyString", "progress", "Lcom/intellij/docker/agent/progress/DockerResponseItem$ProgressDetail;", "cur", "total", "", "getNumberBox", "getTimeLeftBox", "toTerminalString", "Companion", "intellij.clouds.docker.agent.rt"})
public final class DockerProgressDetailsFormat {
    private int ttyWidth = 200;
    private boolean hideCounts;
    @NotNull
    private String units = "";
    private static final String[] BYTE_DECIMAL_NAMES;
    public static final Companion Companion;

    public final int getTtyWidth() {
        return this.ttyWidth;
    }

    public final void setTtyWidth(int n) {
        this.ttyWidth = n;
    }

    public final boolean getHideCounts() {
        return this.hideCounts;
    }

    public final void setHideCounts(boolean bl) {
        this.hideCounts = bl;
    }

    @NotNull
    public final String getUnits() {
        return this.units;
    }

    public final void setUnits(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.units = string;
    }

    @NotNull
    public final String toTtyString(@NotNull DockerResponseItem.ProgressDetail progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        return this.toTerminalString(progress);
    }

    @NotNull
    public final String toTtyString(long cur, long total) {
        return this.toTtyString(new DockerResponseItem.ProgressDetail.Impl(0L, total, cur));
    }

    @NotNull
    public final String toTtyString(int cur, int total) {
        return this.toTtyString((long)cur, (long)total);
    }

    private final String toTerminalString(DockerResponseItem.ProgressDetail $this$toTerminalString) {
        if ($this$toTerminalString.getCurrent() <= 0L && $this$toTerminalString.getTotal() <= 0L) {
            return "";
        }
        if ($this$toTerminalString.getTotal() <= 0L) {
            String string;
            String string2 = this.units;
            switch (string2.hashCode()) {
                case 0: {
                    if (string2.equals("")) {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string3 = "%8s";
                        Object[] objectArray = new Object[]{Companion.humanSizeBytes($this$toTerminalString.getCurrent())};
                        boolean bl = false;
                        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                        string = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                        break;
                    }
                }
                default: {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string5 = "%d %s";
                    Object[] objectArray = new Object[]{$this$toTerminalString.getCurrent(), this.units};
                    boolean bl = false;
                    String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
                }
            }
            return string;
        }
        int n = 50;
        int n2 = MathKt.roundToInt((double)((double)$this$toTerminalString.getCurrent() / (double)$this$toTerminalString.getTotal() * (double)100)) / 2;
        boolean bl = false;
        int percentage = Math.min(n, n2);
        String pbBox = this.getPbBox(percentage);
        String timeLeftBox = this.getTimeLeftBox($this$toTerminalString, percentage);
        String numbersBox = this.getNumberBox($this$toTerminalString);
        return pbBox + numbersBox + timeLeftBox;
    }

    private final String getTimeLeftBox(DockerResponseItem.ProgressDetail $this$getTimeLeftBox, int percentage) {
        if (this.ttyWidth <= 50 || percentage >= 50) {
            return "";
        }
        if ($this$getTimeLeftBox.getCurrent() <= 0L || $this$getTimeLeftBox.getStart() <= 0L) {
            return "";
        }
        long fromStart = System.currentTimeMillis() - $this$getTimeLeftBox.getStart();
        long perEntry = fromStart / $this$getTimeLeftBox.getCurrent();
        Duration left = Duration.of(($this$getTimeLeftBox.getTotal() - $this$getTimeLeftBox.getCurrent()) * perEntry, ChronoUnit.MILLIS);
        StringBuilder stringBuilder = new StringBuilder().append(" ");
        Duration duration = left;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"left");
        return stringBuilder.append(DockerProgressDetailsFormat.Companion.toDockerString(duration)).toString();
    }

    private final String getPbBox(int percentage) {
        if (this.ttyWidth <= 110) {
            return "";
        }
        int n = 0;
        int n2 = 50 - percentage;
        boolean bl = false;
        int numSpaces = Math.max(n, n2);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "[%s>%s]";
        Object[] objectArray = new Object[]{StringsKt.repeat((CharSequence)"=", (int)percentage), StringsKt.repeat((CharSequence)" ", (int)numSpaces)};
        boolean bl2 = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    private final String getNumberBox(DockerResponseItem.ProgressDetail $this$getNumberBox) {
        String string;
        if (this.hideCounts) {
            string = "";
        } else {
            if (Intrinsics.areEqual((Object)this.units, (Object)"")) {
                String string2;
                String currentString = Companion.humanSizeBytes($this$getNumberBox.getCurrent());
                String totalString = Companion.humanSizeBytes($this$getNumberBox.getTotal());
                if ($this$getNumberBox.getCurrent() > $this$getNumberBox.getTotal()) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string3 = "%8s/%s";
                    Object[] objectArray = new Object[]{currentString, totalString};
                    boolean bl = false;
                    String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                } else {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string5 = "%8s";
                    Object[] objectArray = new Object[]{currentString};
                    boolean bl = false;
                    String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                    string2 = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
                }
                return string2;
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string7 = "%d/%d %s";
            Object[] objectArray = new Object[]{$this$getNumberBox.getCurrent(), $this$getNumberBox.getTotal(), this.units};
            boolean bl = false;
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"java.lang.String.format(format, *args)");
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        BYTE_DECIMAL_NAMES = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
    }

    @JvmStatic
    @NotNull
    public static final String humanSizeBytes(double value) {
        return Companion.humanSizeBytes(value);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\tH\u0007J\f\u0010\u000f\u001a\u00020\u0005*\u00020\u0010H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/agent/progress/DockerProgressDetailsFormat$Companion;", "", "()V", "BYTE_DECIMAL_NAMES", "", "", "[Ljava/lang/String;", "getSizeAndUnit", "Lkotlin/Pair;", "", "value", "base", "unitNames", "(DD[Ljava/lang/String;)Lkotlin/Pair;", "humanSizeBytes", "toDockerString", "Ljava/time/Duration;", "intellij.clouds.docker.agent.rt"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final String humanSizeBytes(double value) {
            void size;
            StringCompanionObject stringCompanionObject = this.getSizeAndUnit(value, 1000.0, BYTE_DECIMAL_NAMES);
            double d = ((Number)stringCompanionObject.component1()).doubleValue();
            String unit = (String)stringCompanionObject.component2();
            stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%.4g%s";
            Object[] objectArray = new Object[]{(double)size, unit};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private final Pair<Double, String> getSizeAndUnit(double value, double base, String[] unitNames) {
            double current;
            int idx = 0;
            for (current = value; current > base && idx < unitNames.length - 1; current /= base, ++idx) {
            }
            return new Pair((Object)current, (Object)unitNames[idx]);
        }

        private final String toDockerString(Duration $this$toDockerString) {
            long seconds = $this$toDockerString.getSeconds();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%d:%02d:%02d";
            Object[] objectArray = new Object[]{seconds / (long)3600, seconds % (long)3600 / (long)60, seconds % (long)60};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

