/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.util.ui.ColumnInfo;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;

public class MvcPluginIsInstalledColumnInfo
extends ColumnInfo<MvcPluginDescriptor, Boolean> {
    private final Set<String> toInstallPlugins = new HashSet<String>();
    private final Set<String> toRemovePlugins = new HashSet<String>();
    private final Set<String> myInstalledPlugins;

    public MvcPluginIsInstalledColumnInfo(Set<String> installedPlugins) {
        super(GrailsBundle.message("mvc.plugins.column.name.enable", new Object[0]));
        this.myInstalledPlugins = installedPlugins;
    }

    public boolean isPluginSelectAsInstalled(MvcPluginDescriptor mvcPlugin) {
        if (this.toInstallPlugins.contains(mvcPlugin.getName())) {
            return true;
        }
        if (this.toRemovePlugins.contains(mvcPlugin.getName())) {
            return false;
        }
        return this.myInstalledPlugins.contains(mvcPlugin.getName());
    }

    public Boolean valueOf(MvcPluginDescriptor mvcPlugin) {
        return this.isPluginSelectAsInstalled(mvcPlugin);
    }

    public boolean isCellEditable(MvcPluginDescriptor mvcPlugin) {
        return true;
    }

    public Class getColumnClass() {
        return Boolean.class;
    }

    public TableCellEditor getEditor(MvcPluginDescriptor mvcPlugin) {
        return new BooleanTableCellEditor();
    }

    public TableCellRenderer getRenderer(MvcPluginDescriptor mvcPlugin) {
        return new BooleanTableCellRenderer();
    }

    public void setValue(MvcPluginDescriptor mvcPlugin, Boolean value) {
        String name = mvcPlugin.getName();
        if (value.booleanValue()) {
            if (!this.myInstalledPlugins.contains(name)) {
                this.toInstallPlugins.add(name);
            }
            this.toRemovePlugins.remove(name);
        } else {
            if (this.myInstalledPlugins.contains(name)) {
                this.toRemovePlugins.add(name);
            }
            this.toInstallPlugins.remove(name);
        }
    }

    public Comparator<MvcPluginDescriptor> getComparator() {
        return (mvcPlugin1, mvcPlugin2) -> {
            boolean select2;
            boolean select1 = this.isPluginSelectAsInstalled((MvcPluginDescriptor)mvcPlugin1);
            if (select1 == (select2 = this.isPluginSelectAsInstalled((MvcPluginDescriptor)mvcPlugin2))) {
                return mvcPlugin1.getName().compareToIgnoreCase(mvcPlugin2.getName());
            }
            return select1 ? -1 : 1;
        };
    }

    public int getWidth(JTable table) {
        return 10;
    }

    public Set<String> getToInstallPlugins() {
        return this.toInstallPlugins;
    }

    public Set<String> getToRemovePlugins() {
        return this.toRemovePlugins;
    }
}

