/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SafeReference
implements PsiReference {
    private final PsiReferenceBase myDelegate;
    private final SafeReference myNextReference;

    public SafeReference(PsiReferenceBase delegate, SafeReference nextReference) {
        this.myDelegate = delegate;
        this.myNextReference = nextReference;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myDelegate.getElement();
        if (psiElement == null) {
            SafeReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myDelegate.getRangeInElement();
        if (textRange == null) {
            SafeReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public PsiElement resolve() {
        return this.myDelegate.resolve();
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myDelegate.getCanonicalText();
        if (string == null) {
            SafeReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            SafeReference.$$$reportNull$$$0(3);
        }
        int lengthBefore = this.myDelegate.getRangeInElement().getLength();
        PsiElement res = this.myDelegate.handleElementRename(newElementName);
        int delta = this.myDelegate.getRangeInElement().getLength() - lengthBefore;
        SafeReference ref = this.myNextReference;
        while (ref != null) {
            ref.myDelegate.setRangeInElement(ref.getRangeInElement().shiftRight(delta));
            ref = ref.myNextReference;
        }
        return res;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            SafeReference.$$$reportNull$$$0(4);
        }
        return this.myDelegate.bindToElement(element);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            SafeReference.$$$reportNull$$$0(5);
        }
        return this.myDelegate.isReferenceTo(element);
    }

    public Object @NotNull [] getVariants() {
        Object[] objectArray = this.myDelegate.getVariants();
        if (objectArray == null) {
            SafeReference.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return this.myDelegate.isSoft();
    }

    public static void makeReferencesSafe(PsiReference @NotNull [] referencesInSameElement) {
        if (referencesInSameElement == null) {
            SafeReference.$$$reportNull$$$0(7);
        }
        if (referencesInSameElement.length < 2) {
            return;
        }
        int last = referencesInSameElement.length - 1;
        referencesInSameElement[last] = new SafeReference((PsiReferenceBase)referencesInSameElement[last], null);
        for (int i2 = last; i2 > 0; --i2) {
            PsiReference ref1 = referencesInSameElement[i2 - 1];
            PsiReference ref2 = referencesInSameElement[i2];
            assert (ref1.getRangeInElement().getEndOffset() <= ref2.getRangeInElement().getStartOffset());
            assert (ref1.getElement() == ref2.getElement());
            referencesInSameElement[i2 - 1] = new SafeReference((PsiReferenceBase)ref1, (SafeReference)ref2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/util/SafeReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencesInSameElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/util/SafeReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "makeReferencesSafe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

