/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.util.version.Range;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.grails.util.version.VersionImpl;

public class GrailsSDKHomeForm {
    private static final FileChooserDescriptor FILE_CHOOSER_DESCRIPTOR = new FileChooserDescriptor(false, true, false, false, false, false){

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            return super.isFileVisible(file, showHiddenFiles) && file.isDirectory();
        }

        public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
            if (files == null) {
                1.$$$reportNull$$$0(0);
            }
            assert (files.length == 1);
            VirtualFile file = files[0];
            String version = GrailsConfigUtils.getInstance().getSDKVersion(file.getPath());
            if (version == "undefined") {
                throw new Exception(ProjectBundle.message((String)(file.isDirectory() ? "sdk.configure.home.invalid.error" : "sdk.configure.home.file.invalid.error"), (Object[])new Object[]{"Grails SDK"}));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/plugins/grails/ui/GrailsSDKHomeForm$1", "validateSelectedFiles"));
        }
    }.withShowHiddenFiles(true);
    private JPanel myComponent;
    private TextFieldWithBrowseButton myPath;
    private JBLabel myVersionLabel;
    @Nullable
    private Range<Version> myVersionRange;
    @Nullable
    private Runnable myChangedCallback;
    private GrailsSDK mySelectedSdk;

    public GrailsSDKHomeForm() {
        this.$$$setupUI$$$();
        this.myPath.addBrowseFolderListener(new TextBrowseFolderListener(FILE_CHOOSER_DESCRIPTOR){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                GrailsSDKHomeForm.this.validate();
                if (GrailsSDKHomeForm.this.myChangedCallback != null) {
                    GrailsSDKHomeForm.this.myChangedCallback.run();
                }
            }

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file = super.getInitialFile();
                if (file != null) {
                    return file;
                }
                VirtualFile gvmCurrent = VfsUtil.findRelativeFile((VirtualFile)VfsUtil.getUserHomeDir(), (String[])new String[]{".gvm", "grails", "current"});
                if (gvmCurrent != null) {
                    return gvmCurrent;
                }
                return VfsUtil.findRelativeFile((VirtualFile)VfsUtil.getUserHomeDir(), (String[])new String[]{".sdkman", "grails", "current"});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "org/jetbrains/plugins/grails/ui/GrailsSDKHomeForm$2", "onFileChosen"));
            }
        });
        this.myPath.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                GrailsSDKHomeForm.this.validate();
                if (GrailsSDKHomeForm.this.myChangedCallback != null) {
                    GrailsSDKHomeForm.this.myChangedCallback.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/grails/ui/GrailsSDKHomeForm$3", "textChanged"));
            }
        });
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getPathComponent() {
        return this.myPath;
    }

    @NotNull
    public GrailsSDK getSelectedSdk() {
        GrailsSDK grailsSDK = Objects.requireNonNull(this.mySelectedSdk);
        if (grailsSDK == null) {
            GrailsSDKHomeForm.$$$reportNull$$$0(0);
        }
        return grailsSDK;
    }

    public GrailsSDKHomeForm setPath(String path) {
        this.myPath.setText(path);
        this.validate();
        return this;
    }

    public GrailsSDKHomeForm setVersionRange(@Nullable Range<Version> versionRange) {
        this.myVersionRange = versionRange;
        this.validate();
        return this;
    }

    public GrailsSDKHomeForm setChangedCallback(@Nullable Runnable changedCallback) {
        this.myChangedCallback = changedCallback;
        return this;
    }

    public GrailsSDKHomeForm setEditable(boolean editable) {
        this.myPath.setEditable(editable);
        this.myPath.setButtonEnabled(editable);
        return this;
    }

    public boolean validate() {
        String path = this.myPath.getText();
        if (StringUtil.isEmpty((String)path)) {
            return this.error(GrailsBundle.message("sdk.home.form.label.text.sdk.not.selected", new Object[0]));
        }
        String version = GrailsConfigUtils.getInstance().getSDKVersion(path);
        if (version == "undefined") {
            return this.error(GrailsBundle.message("sdk.home.form.label.text.cannot.determine.grails.sdk.version", new Object[0]));
        }
        if (this.myVersionRange == null || this.myVersionRange.contains(new VersionImpl(version))) {
            this.mySelectedSdk = new GrailsSDK(path, new VersionImpl(version));
            return this.message(GrailsBundle.message("sdk.home.form.label.text.version", version), false);
        }
        return this.error(GrailsBundle.message("sdk.home.form.label.text.version.range.error", GrailsSDKHomeForm.prettyPrint(this.myVersionRange)));
    }

    private boolean error(@NlsContexts.Label String message) {
        this.mySelectedSdk = null;
        return this.message(message, true);
    }

    private boolean message(@NlsContexts.Label String message, boolean isError) {
        HtmlBuilder builder = new HtmlBuilder();
        builder.append((HtmlChunk)HtmlChunk.html().children(new HtmlChunk[]{HtmlChunk.raw((String)message)}));
        this.myVersionLabel.setText(builder.toString());
        this.myVersionLabel.setForeground((Color)(isError ? JBColor.RED : JBColor.foreground()));
        return !isError;
    }

    @NotNull
    private static String prettyPrint(@NotNull Range<Version> range) {
        if (range == null) {
            GrailsSDKHomeForm.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        if (range.getStart() != null) {
            sb.append(range.isStartInclusive() ? "at least" : "more than").append(" ").append(range.getStart());
        }
        if (range.getStart() != null && range.getEnd() != null) {
            sb.append(" and ");
        }
        if (range.getEnd() != null) {
            sb.append(range.isEndInclusive() ? "not more than" : "less than").append(" ").append(range.getEnd());
        }
        String string = sb.toString();
        if (string == null) {
            GrailsSDKHomeForm.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/ui/GrailsSDKHomeForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedSdk";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/ui/GrailsSDKHomeForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prettyPrint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prettyPrint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myComponent = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/GrailsBundle", GrailsSDKHomeForm.class).getString("sdk.home.form.label.grails.sdk.home"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 3, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVersionLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setEnabled(true);
        jBLabel.setText("");
        jBLabel.setVisible(true);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 1, 1, 0, 6, null, new Dimension(500, -1), null, 1));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

