/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.runner.ui.GrailsApplicationCombobox;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.structure.Grails3Application;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.ui.GrailsSDKHomeForm;
import org.jetbrains.plugins.grails.util.version.Range;
import org.jetbrains.plugins.grails.util.version.Version;

public class GrailsConfigureSDKDialog
extends DialogWrapper {
    private final GrailsSDKHomeForm mySDKHomeForm;
    private JPanel myCenterPanel;
    private GrailsApplicationCombobox myApplicationCombobox;
    private JPanel mySDKFormPanel;
    private JLabel myApplicationLabel;

    public GrailsConfigureSDKDialog(@NotNull Project project) {
        if (project == null) {
            GrailsConfigureSDKDialog.$$$reportNull$$$0(0);
        }
        super(project, false, DialogWrapper.IdeModalityType.IDE);
        this.$$$setupUI$$$();
        this.mySDKHomeForm = new GrailsSDKHomeForm();
        this.mySDKHomeForm.setChangedCallback(this::checkOkAction);
        this.mySDKFormPanel.add((Component)this.mySDKHomeForm.getComponent(), "Center");
        this.myApplicationLabel.setLabelFor((Component)((Object)this.myApplicationCombobox));
        this.myApplicationCombobox.disallowEmptySelection();
        this.myApplicationCombobox.setApplications(GrailsApplicationManager.getInstance(project).getApplications());
        this.myApplicationCombobox.addItemListener(e -> {
            GrailsApplication selectedApplication = this.myApplicationCombobox.getSelectedApplication();
            this.mySDKHomeForm.setVersionRange(GrailsConfigureSDKDialog.getVersionRange(selectedApplication));
            this.mySDKHomeForm.setPath(GrailsSDKManager.getGrailsSdkPath(selectedApplication));
        });
        this.myApplicationCombobox.addItemListener(e -> this.checkOkAction());
        this.setTitle(GrailsBundle.message("grails.configure.sdk", new Object[0]));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySDKHomeForm.getPathComponent();
    }

    private void checkOkAction() {
        this.setOKActionEnabled(this.myApplicationCombobox.getSelectedApplication() != null && this.mySDKHomeForm.validate());
    }

    @NotNull
    public GrailsConfigureSDKDialog setGrailsApplication(@Nullable GrailsApplication application) {
        this.myApplicationCombobox.setSelectedApplication(application);
        GrailsConfigureSDKDialog grailsConfigureSDKDialog = this;
        if (grailsConfigureSDKDialog == null) {
            GrailsConfigureSDKDialog.$$$reportNull$$$0(1);
        }
        return grailsConfigureSDKDialog;
    }

    protected void doOKAction() {
        GrailsApplication application = this.myApplicationCombobox.getSelectedApplication();
        assert (application != null);
        GrailsSDKManager.setGrailsSDK(application, this.mySDKHomeForm.getSelectedSdk().getPath());
        super.doOKAction();
    }

    @Nullable
    private static Range<Version> getVersionRange(@Nullable GrailsApplication application) {
        if (application == null) {
            return null;
        }
        if (application instanceof OldGrailsApplication) {
            return Version.LESS_THAN_3;
        }
        if (application instanceof Grails3Application) {
            return Version.AT_LEAST_3;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/ui/GrailsConfigureSDKDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/ui/GrailsConfigureSDKDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setGrailsApplication";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        GrailsApplicationCombobox grailsApplicationCombobox;
        JLabel jLabel;
        JPanel jPanel2;
        this.myCenterPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "Center");
        this.myApplicationLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/GrailsBundle", GrailsConfigureSDKDialog.class).getString("sdk.form.label.application"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApplicationCombobox = grailsApplicationCombobox = new GrailsApplicationCombobox();
        jPanel3.add((Component)((Object)grailsApplicationCombobox), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.mySDKFormPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myCenterPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

