/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.tests.runner;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.execution.ParametersListUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.tests.runner.ByDirectoryKt;
import org.jetbrains.plugins.grails.tests.runner.GrailsTestConfigurationProducer;
import org.jetbrains.plugins.grails.tests.runner.OldUtilsKt;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.grails.util.version.VersionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0012"}, d2={"suffixes", "", "", "[Ljava/lang/String;", "setupConfigurationByClass", "Lcom/intellij/psi/PsiElement;", "configuration", "Lorg/jetbrains/plugins/grails/runner/GrailsRunConfiguration;", "application", "Lorg/jetbrains/plugins/grails/structure/GrailsApplication;", "aClass", "Lcom/intellij/psi/PsiClass;", "method", "Lcom/intellij/psi/PsiMethod;", "trimTestSuffix", "name", "useMethod", "", "intellij.groovy.grails"})
public final class ByClassKt {
    private static final String[] suffixes = new String[]{"Tests", "Test"};

    @Nullable
    public static final PsiElement setupConfigurationByClass(@NotNull GrailsRunConfiguration configuration, @NotNull GrailsApplication application, @NotNull PsiClass aClass, @Nullable PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        String string = aClass.getQualifiedName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aClass.qualifiedName ?: return null");
        String classFqn = string;
        String string2 = aClass.getName();
        if (string2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"aClass.name ?: return null");
        String className = string2;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)aClass.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(aClass.project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026aClass.project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        PsiFile psiFile = aClass.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"aClass.containingFile");
        VirtualFile virtualFile = fileIndex.getSourceRootForFile(psiFile.getVirtualFile());
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"fileIndex.getSourceRootF\u2026rtualFile) ?: return null");
        VirtualFile srcRoot = virtualFile;
        boolean v3 = application.getGrailsVersion().compareTo(VersionsKt.getV3()) >= 0;
        StringBuilder parameters = new StringBuilder("test-app");
        if (!v3) {
            String string3 = OldUtilsKt.getParamKeyByTestRoot(application, srcRoot);
            if (string3 == null) {
                return null;
            }
            String testKind = string3;
            parameters.append(" ").append(testKind);
        }
        String testName = ByClassKt.trimTestSuffix(classFqn);
        String configurationName = null;
        String testFilter = null;
        PsiElement sourceElement = null;
        if (method != null && ByClassKt.useMethod(application, method)) {
            String string4 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"method.name");
            String methodName = string4;
            configurationName = methodName + "()";
            String string5 = ParametersListUtil.join((String[])new String[]{testName + "." + methodName});
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"ParametersListUtil.join(\u2026tName + \".\" + methodName)");
            testFilter = string5;
            sourceElement = (PsiElement)method;
        } else {
            configurationName = className;
            testFilter = testName;
            sourceElement = (PsiElement)aClass;
        }
        parameters.append(" ").append(testFilter);
        if (v3) {
            VirtualFile integrationTestRoot = ByDirectoryKt.findIntegrationTestDirV3(application);
            boolean integrationTest = integrationTestRoot != null && VfsUtilCore.isAncestor((VirtualFile)integrationTestRoot, (VirtualFile)srcRoot, (boolean)true);
            parameters.append(" ").append(integrationTest ? "-integration" : "-unit");
        }
        configuration.setName(configurationName);
        configuration.setProgramParameters(parameters.toString());
        return sourceElement;
    }

    private static final boolean useMethod(GrailsApplication application, PsiMethod method) {
        Version version = application.getGrailsVersion();
        if (version.compareTo(VersionsKt.getV11()) < 0 || !GrailsTestConfigurationProducer.isGrailsTestMethod(method)) {
            return false;
        }
        if (version.compareTo(VersionsKt.getV3()) > 0) {
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)" ", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        return true;
    }

    private static final String trimTestSuffix(String name) {
        for (String suffix : suffixes) {
            if (!StringsKt.endsWith$default((String)name, (String)suffix, (boolean)false, (int)2, null)) continue;
            return StringsKt.removeSuffix((String)name, (CharSequence)suffix);
        }
        return name;
    }
}

