/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.tests;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrailsTestMemberContributor
extends NonCodeMembersContributor {
    private static final Map<GrailsArtifact, Couple<String>> MAP = GrailsUtils.createMap(new Object[]{GrailsArtifact.CONTROLLER, Couple.of((Object)"controller", (Object)"grails.test.mixin.web.ControllerUnitTestMixin"), GrailsArtifact.TAGLIB, Couple.of((Object)"tagLib", (Object)"grails.test.mixin.web.GroovyPageUnitTestMixin"), GrailsArtifact.FILTER, Couple.of((Object)"filters", (Object)"grails.test.mixin.web.FiltersUnitTestMixin"), GrailsArtifact.URLMAPPINGS, Couple.of((Object)"urlMappings", (Object)"grails.test.mixin.web.UrlMappingsUnitTestMixin"), GrailsArtifact.SERVICE, Couple.of((Object)"service", (Object)"grails.test.mixin.services.ServiceUnitTestMixin"), GrailsArtifact.DOMAIN, Couple.of((Object)"domain", (Object)"grails.test.mixin.domain.DomainClassUnitTestMixin")});

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        PsiElement mixinClass;
        GrailsArtifact artifactType;
        Couple<String> testDataDescriptor;
        PsiElement artifactClass;
        PsiAnnotationMemberValue value;
        if (qualifierType == null) {
            GrailsTestMemberContributor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            GrailsTestMemberContributor.$$$reportNull$$$0(1);
        }
        if (place == null) {
            GrailsTestMemberContributor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            GrailsTestMemberContributor.$$$reportNull$$$0(3);
        }
        if (!(aClass instanceof GrTypeDefinition)) {
            return;
        }
        GrTypeDefinition testClass = (GrTypeDefinition)aClass;
        if (PsiTreeUtil.getParentOfType((PsiElement)place, GrAnnotation.class) != null) {
            return;
        }
        GrModifierList modifierList = testClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiAnnotation testForAnnotation = modifierList.findAnnotation("grails.test.mixin.TestFor");
        PsiAnnotation testMixinAnnotation = modifierList.findAnnotation("grails.test.mixin.TestMixin");
        PsiAnnotation testMockAnnotation = modifierList.findAnnotation("grails.test.mixin.Mock");
        if (testForAnnotation == null && testMixinAnnotation == null && testMockAnnotation == null) {
            return;
        }
        String nameHint = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (ResolveUtil.shouldProcessProperties((ElementClassHint)classHint) && !GrailsPsiUtil.processLogVariable(processor, (PsiClass)testClass, nameHint)) {
            return;
        }
        PsiElement processedMixinClass = null;
        if (testForAnnotation != null && (value = testForAnnotation.findAttributeValue("value")) instanceof GrReferenceExpression && (artifactClass = ((GrReferenceExpression)value).resolve()) instanceof PsiClass && (testDataDescriptor = MAP.get((Object)(artifactType = GrailsArtifact.getType((PsiClass)artifactClass)))) != null) {
            if (ResolveUtil.shouldProcessProperties((ElementClassHint)classHint)) {
                String qualifiedName;
                String instancePropertyName = (String)testDataDescriptor.first;
                if ((nameHint == null || instancePropertyName.equals(nameHint)) && testClass.findFieldByName(instancePropertyName, false) == null && (qualifiedName = ((PsiClass)artifactClass).getQualifiedName()) != null) {
                    GrLightField field = new GrLightField((PsiClass)testClass, instancePropertyName, qualifiedName);
                    field.getModifierList().setModifiers(2);
                    if (!processor.execute((PsiElement)field, state)) {
                        return;
                    }
                }
            }
            if (ResolveUtil.shouldProcessMethods((ElementClassHint)classHint) && (mixinClass = JavaPsiFacade.getInstance((Project)testClass.getProject()).findClass((String)testDataDescriptor.second, testClass.getResolveScope())) != null) {
                processedMixinClass = mixinClass;
                if (!GrailsTestMemberContributor.processMethodsFromMixinClass(processor, testClass, (PsiClass)mixinClass, nameHint, state)) {
                    return;
                }
            }
        }
        if (ResolveUtil.shouldProcessMethods((ElementClassHint)classHint)) {
            if (!GrailsTestMemberContributor.processAssertMethods(processor, (PsiClass)testClass, state)) {
                return;
            }
            if (testMixinAnnotation != null) {
                PsiAnnotationMemberValue value2 = testMixinAnnotation.findAttributeValue("value");
                List<Object> values = value2 instanceof GrReferenceExpression ? Collections.singletonList(value2) : (value2 instanceof GrAnnotationArrayInitializer ? Arrays.asList(((GrAnnotationArrayInitializer)value2).getInitializers()) : Collections.emptyList());
                for (PsiAnnotationMemberValue v : values) {
                    if (!(v instanceof GrReferenceExpression) || !((mixinClass = ((GrReferenceExpression)v).resolve()) instanceof PsiClass) || mixinClass == processedMixinClass || GrailsTestMemberContributor.processMethodsFromMixinClass(processor, testClass, (PsiClass)mixinClass, nameHint, state)) continue;
                    return;
                }
            }
        }
    }

    private static boolean processMethodsFromMixinClass(PsiScopeProcessor processor, GrTypeDefinition testClass, PsiClass mixinClass, @Nullable String nameHint, ResolveState state) {
        PsiMethod[] methods;
        PsiMethod[] psiMethodArray = methods = nameHint == null ? mixinClass.getAllMethods() : mixinClass.findMethodsByName(nameHint, true);
        if (methods.length == 0) {
            return true;
        }
        PsiClass groovyObjectSupport = JavaPsiFacade.getInstance((Project)testClass.getProject()).findClass("groovy.lang.GroovyObjectSupport", testClass.getResolveScope());
        for (PsiMethod method : methods) {
            if (!GrailsTestMemberContributor.isCandidateMethod(method, groovyObjectSupport) || testClass.findCodeMethodsBySignature(method, true).length != 0 || processor.execute((PsiElement)method, state)) continue;
            return false;
        }
        return true;
    }

    private static boolean processAssertMethods(PsiScopeProcessor processor, @NotNull PsiClass aClass, ResolveState state) {
        if (aClass == null) {
            GrailsTestMemberContributor.$$$reportNull$$$0(4);
        }
        return GrailsPsiUtil.process("org.junit.Assert", processor, (PsiElement)aClass, state);
    }

    private static boolean isCandidateMethod(@NotNull PsiMethod method, @Nullable PsiClass groovyObjectSupport) {
        String name;
        if (method == null) {
            GrailsTestMemberContributor.$$$reportNull$$$0(5);
        }
        if ((name = method.getName()).indexOf(36) != -1) {
            return false;
        }
        if (method.hasModifierProperty("private") || method.hasModifierProperty("protected") || method.hasModifierProperty("abstract")) {
            return false;
        }
        return groovyObjectSupport == null || groovyObjectSupport.findMethodBySignature(method, true) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/tests/GrailsTestMemberContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDynamicElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processAssertMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isCandidateMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

