/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.sync;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.structure.GrailsApplicationListener;
import org.jetbrains.plugins.grails.structure.GrailsSDKListener;
import org.jetbrains.plugins.grails.structure.impl.Grails2Application;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;

public class GrailsMvcStructureRefresher
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            GrailsMvcStructureRefresher.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        MvcModuleStructureSynchronizer synchronizer = MvcModuleStructureSynchronizer.getInstance((Project)project);
        MessageBusConnection connection2 = project.getMessageBus().connect();
        connection2.subscribe(GrailsApplicationListener.TOPIC, () -> {
            synchronizer.getFileAndRootsModificationTracker().incModificationCount();
            ApplicationManager.getApplication().invokeLater(() -> {
                synchronizer.queue(MvcModuleStructureSynchronizer.SyncAction.UpdateProjectStructure, (Object)project);
                synchronizer.queue(MvcModuleStructureSynchronizer.SyncAction.UpgradeFramework, (Object)project);
            }, project.getDisposed());
        });
        connection2.subscribe(GrailsSDKListener.TOPIC, application -> {
            if (!(application instanceof Grails2Application)) {
                return;
            }
            synchronizer.getFileAndRootsModificationTracker().incModificationCount();
            Module module = ((Grails2Application)application).getModule();
            ApplicationManager.getApplication().invokeLater(() -> GrailsFramework.forceSynchronizationSetting(module), module.getDisposed());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsMvcStructureRefresher", "runActivity"));
    }
}

