/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;

public class GrailsApplicationManagerRefresher
implements StartupActivity.DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            GrailsApplicationManagerRefresher.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final GrailsApplicationManager manager = GrailsApplicationManager.getInstance(project);
        MessageBusConnection connection2 = project.getMessageBus().connect((Disposable)manager);
        connection2.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Boolean inProgress;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((inProgress = (Boolean)project.getUserData(GrailsFramework.UPDATE_IN_PROGRESS)) != null && inProgress.booleanValue()) {
                    return;
                }
                manager.queueUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/grails/structure/GrailsApplicationManagerRefresher$1", "rootsChanged"));
            }
        });
        connection2.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){
            final ProjectFileIndex myFileIndex;
            {
                this.myFileIndex = ProjectFileIndex.getInstance((Project)project);
            }

            boolean shouldClearApplications(@NotNull VirtualFileEvent event) {
                VirtualFile file;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!this.myFileIndex.isInContent(file = event.getFile())) {
                    return false;
                }
                String fileName = event.getFileName();
                return file.isDirectory() && fileName.equals("grails-app") || !file.isDirectory() && fileName.equals("application.properties");
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (this.shouldClearApplications(event)) {
                    manager.queueUpdate();
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (this.shouldClearApplications(event)) {
                    manager.queueUpdate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/grails/structure/GrailsApplicationManagerRefresher$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldClearApplications";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
        connection2.subscribe(GradleSettingsListener.TOPIC, (Object)new GradleSettingsListenerAdapter(){

            public void onProjectsLinked(@NotNull Collection<GradleProjectSettings> settings) {
                if (settings == null) {
                    3.$$$reportNull$$$0(0);
                }
                manager.queueUpdate();
            }

            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                if (linkedProjectPaths == null) {
                    3.$$$reportNull$$$0(1);
                }
                manager.queueUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "linkedProjectPaths";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/grails/structure/GrailsApplicationManagerRefresher$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onProjectsLinked";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onProjectsUnlinked";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/GrailsApplicationManagerRefresher", "runActivity"));
    }
}

