/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.util.GrailsFacetProvider;

public class GrailsSpringFacetProvider
implements GrailsFacetProvider {
    @NonNls
    private static final String GRAILS_FILESET = "Grails";
    private static final String[] configurationLocations = new String[]{"web-app/WEB-INF/applicationContext.xml", "grails-app/conf/spring/resources.xml"};

    @Override
    public void addFacets(Collection<Consumer<ModifiableFacetModel>> actions, Module module, Collection<VirtualFile> roots) {
        ArrayList<VirtualFile> configFiles = new ArrayList<VirtualFile>();
        for (VirtualFile root : roots) {
            for (String configurationLocation : configurationLocations) {
                VirtualFile appContext = root.findFileByRelativePath(configurationLocation);
                if (appContext == null) continue;
                configFiles.add(appContext);
            }
        }
        actions.add((Consumer<ModifiableFacetModel>)((Consumer)model -> {
            Collection facets = model.getFacetsByType(SpringFacet.FACET_TYPE_ID);
            if (facets.isEmpty()) {
                SpringFacet facet = (SpringFacet)SpringFacet.getSpringFacetType().createFacet(module, GrailsBundle.message("grails.spring.facet.name", new Object[0]), (FacetConfiguration)((SpringFacetConfiguration)SpringFacet.getSpringFacetType().createDefaultConfiguration()), null);
                if (!configFiles.isEmpty()) {
                    SpringFileSet fileSet = facet.addFileSet(GRAILS_FILESET, GRAILS_FILESET);
                    for (VirtualFile configFile : configFiles) {
                        fileSet.addFile(configFile);
                    }
                }
                model.addFacet((Facet)facet);
            } else if (!configFiles.isEmpty()) {
                SpringFileSet fileSet = null;
                for (SpringFacet springFacet : facets) {
                    for (SpringFileSet set : springFacet.getFileSets()) {
                        if (GRAILS_FILESET.equals(set.getId())) {
                            fileSet = set;
                        }
                        Iterator itr = configFiles.iterator();
                        while (itr.hasNext()) {
                            VirtualFile file = (VirtualFile)itr.next();
                            if (!set.hasFile(file)) continue;
                            itr.remove();
                        }
                    }
                }
                if (fileSet == null) {
                    SpringFacet facet = (SpringFacet)ContainerUtil.getFirstItem((Collection)facets);
                    assert (facet != null);
                    fileSet = facet.addFileSet(GRAILS_FILESET, GRAILS_FILESET);
                }
                if (fileSet != null) {
                    for (VirtualFile configFile : configFiles) {
                        fileSet.addFile(configFile);
                    }
                }
            }
        }));
    }
}

