/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.custom.CustomModuleComponentsDiscoverer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.plugins.ImplKt;
import org.jetbrains.plugins.grails.spring.GrailsCustomSpringComponent;
import org.jetbrains.plugins.grails.spring.GrailsResourceBeanExtractor;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class GrailsSpringBeanDiscoverer
extends CustomModuleComponentsDiscoverer {
    private static final MultiMap<String, Couple<String>> PLUGINS_BEAN_MAP = new MultiMap();
    private static final Couple<String>[] COMMON_BEANS = new Couple[]{Couple.of((Object)"messageSource", (Object)"org.codehaus.groovy.grails.context.support.PluginAwareResourceBundleMessageSource"), Couple.of((Object)"grailsUrlMappingsHolder", (Object)"org.codehaus.groovy.grails.web.mapping.UrlMappingsHolderFactoryBean")};
    private static final Trinity<String, String, String>[] BEANS_BY_GRAILS_VERSION = new Trinity[]{Trinity.create((Object)"2.0.0", (Object)"grailsLinkGenerator", (Object)"org.codehaus.groovy.grails.web.mapping.LinkGenerator"), Trinity.create((Object)"2.0.0", (Object)"groovyPageRenderer", (Object)"grails.gsp.PageRenderer")};

    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@Nullable Module module) {
        if (module == null) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                GrailsSpringBeanDiscoverer.$$$reportNull$$$0(0);
            }
            return list;
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(this.evaluateCustomComponents(module), this.getDependencies(module)));
        if (collection == null) {
            GrailsSpringBeanDiscoverer.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<CommonSpringBean> evaluateCustomComponents(Module module) {
        GrailsFramework grailsFramework = GrailsFramework.getInstance();
        if (grailsFramework.isCommonPluginsModule(module)) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                GrailsSpringBeanDiscoverer.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<CommonSpringBean> result2 = new ArrayList<CommonSpringBean>();
        GrailsStructure structure = GrailsStructure.getInstance(module);
        if (structure == null) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                GrailsSpringBeanDiscoverer.$$$reportNull$$$0(3);
            }
            return list;
        }
        for (GrClassDefinition classDefinition : GrailsArtifact.SERVICE.getInstances(module).values()) {
            result2.add((CommonSpringBean)new CustomSpringComponent((PsiClass)classDefinition));
        }
        THashSet existBeans = new THashSet();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        for (Couple<String> couple : COMMON_BEANS) {
            GrailsSpringBeanDiscoverer.addBeanIfClassExists(result2, (Set<String>)existBeans, facade, scope, (String)couple.first, (String)couple.second);
        }
        for (String pluginName : ContainerUtil.concat(structure.getInstalledCommonPlugins().keySet(), GrailsSpringBeanDiscoverer.getPluginsNamesFromDescriptors(module))) {
            for (Couple couple : PLUGINS_BEAN_MAP.get((Object)pluginName)) {
                GrailsSpringBeanDiscoverer.addBeanIfClassExists(result2, (Set<String>)existBeans, facade, scope, (String)couple.first, (String)couple.second);
            }
        }
        for (Trinity<String, String, String> trinity : BEANS_BY_GRAILS_VERSION) {
            if (!structure.isAtLeastGrails((String)trinity.first)) continue;
            GrailsSpringBeanDiscoverer.addBeanIfClassExists(result2, (Set<String>)existBeans, facade, scope, (String)trinity.second, (String)trinity.third);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        GrailsSpringBeanDiscoverer.addBeanFromResourceGroovy(result2, (Set<String>)existBeans, psiManager, structure.getAppRoot());
        Module commonPluginsModule = grailsFramework.findCommonPluginsModule(module);
        if (commonPluginsModule != null) {
            block5: for (VirtualFile root : ModuleRootManager.getInstance((Module)commonPluginsModule).getContentRoots()) {
                GrailsSpringBeanDiscoverer.addBeanFromResourceGroovy(result2, (Set<String>)existBeans, psiManager, root);
                for (VirtualFile file : root.getChildren()) {
                    GrTypeDefinition pluginClass;
                    if (!file.getName().endsWith("GrailsPlugin.groovy") || (pluginClass = GroovyUtils.getPublicClass((VirtualFile)file, (PsiManager)psiManager)) == null) continue;
                    List<GrailsResourceBeanExtractor.BeanDescriptor> descriptors = GrailsResourceBeanExtractor.getBeanDescriptorsFromPluginClass(pluginClass);
                    GrailsSpringBeanDiscoverer.convertBeans(result2, (Set<String>)existBeans, descriptors);
                    continue block5;
                }
            }
        } else {
            AllClassesSearch.search((SearchScope)scope, (Project)module.getProject(), name -> name.endsWith("GrailsPlugin")).forEach(clazz -> {
                if (!(clazz instanceof GrTypeDefinition)) {
                    clazz = clazz.getNavigationElement();
                }
                if (!(clazz instanceof GrTypeDefinition)) {
                    return;
                }
                List<GrailsResourceBeanExtractor.BeanDescriptor> descriptors = GrailsResourceBeanExtractor.getBeanDescriptorsFromPluginClass((GrTypeDefinition)clazz);
                GrailsSpringBeanDiscoverer.convertBeans(result2, (Set<String>)existBeans, descriptors);
            });
        }
        ArrayList<CommonSpringBean> arrayList = result2;
        if (arrayList == null) {
            GrailsSpringBeanDiscoverer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> getPluginsNamesFromDescriptors(Module module) {
        GrailsApplication application = GrailsApplicationManager.getInstance(module.getProject()).findApplication(module.getModuleFile());
        if (application == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GrailsSpringBeanDiscoverer.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<String> list = ImplKt.computePlugins(application).stream().map(p -> p.getPluginName()).collect(Collectors.toList());
        if (list == null) {
            GrailsSpringBeanDiscoverer.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static void addBeanIfClassExists(List<CommonSpringBean> result2, Set<String> existBeans, JavaPsiFacade facade, GlobalSearchScope scope, String beanName, String className) {
        if (existBeans.contains(beanName)) {
            return;
        }
        PsiClass beanClass = facade.findClass(className, scope);
        if (beanClass != null) {
            result2.add((CommonSpringBean)new GrailsCustomSpringComponent(beanClass, beanName));
            existBeans.add(beanName);
        }
    }

    private static void convertBeans(List<CommonSpringBean> result2, Set<String> existBeans, Collection<GrailsResourceBeanExtractor.BeanDescriptor> descriptors) {
        for (GrailsResourceBeanExtractor.BeanDescriptor bean : descriptors) {
            PsiClass resolveResult;
            if (existBeans.contains(bean.getName()) || (resolveResult = (PsiClass)RecursionManager.doPreventingRecursion((Object)bean, (boolean)true, () -> {
                PsiType type = bean.getType();
                if (type instanceof PsiClassType) {
                    return ((PsiClassType)type).resolve();
                }
                return null;
            })) == null) continue;
            result2.add((CommonSpringBean)new GrailsCustomSpringComponent(resolveResult, bean.getName()));
            existBeans.add(bean.getName());
        }
    }

    private static void addBeanFromResourceGroovy(List<CommonSpringBean> result2, Set<String> existBeans, PsiManager manager, VirtualFile rootDirectory) {
        VirtualFile resourcesFile = VfsUtil.findRelativeFile((VirtualFile)rootDirectory, (String[])new String[]{"grails-app", "conf", "spring", "resources.groovy"});
        if (resourcesFile == null) {
            return;
        }
        PsiFile resourcePsiFile = manager.findFile(resourcesFile);
        if (!(resourcePsiFile instanceof GroovyFile)) {
            return;
        }
        List<GrailsResourceBeanExtractor.BeanDescriptor> descriptors = GrailsResourceBeanExtractor.getBeanDescriptorsFromResourcesGroovy((GroovyFile)resourcePsiFile);
        GrailsSpringBeanDiscoverer.convertBeans(result2, existBeans, descriptors);
    }

    public Object[] getDependencies(@NotNull Module module) {
        if (module == null) {
            GrailsSpringBeanDiscoverer.$$$reportNull$$$0(7);
        }
        return ArrayUtil.append((Object[])SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies(), (Object)PsiModificationTracker.MODIFICATION_COUNT);
    }

    @NotNull
    public String getProviderName() {
        return "Grails Spring Beans";
    }

    static {
        PLUGINS_BEAN_MAP.put((Object)"hibernate", Arrays.asList(Couple.of((Object)"hibernateProperties", (Object)"org.springframework.beans.factory.config.PropertiesFactoryBean"), Couple.of((Object)"sessionFactory", (Object)"org.codehaus.groovy.grails.orm.hibernate.ConfigurableLocalSessionFactoryBean"), Couple.of((Object)"sessionFactory", (Object)"org.grails.orm.hibernate.HibernateMappingContextSessionFactoryBean"), Couple.of((Object)"transactionManager", (Object)"org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateTransactionManager")));
        List<Couple> shiroBeans = Collections.singletonList(Couple.of((Object)"jsecSecurityManager", (Object)"org.jsecurity.web.DefaultWebSecurityManager"));
        PLUGINS_BEAN_MAP.put((Object)"shiro", shiroBeans);
        PLUGINS_BEAN_MAP.put((Object)"jsecurity", shiroBeans);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/spring/GrailsSpringBeanDiscoverer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponents";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateCustomComponents";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsNamesFromDescriptors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/spring/GrailsSpringBeanDiscoverer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

