/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrailsResourceBeanExtractor {
    private static boolean isLooksLikeClassReference(@NotNull GrExpression expression) {
        if (expression == null) {
            GrailsResourceBeanExtractor.$$$reportNull$$$0(0);
        }
        if (!(expression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression ref = (GrReferenceExpression)expression;
        PsiElement nameElement = ref.getReferenceNameElement();
        if (!PsiImplUtil.isLeafElementOfType((PsiElement)nameElement, (IElementType)GroovyTokenTypes.mIDENT)) {
            return false;
        }
        String text = nameElement.getText();
        if (text.isEmpty() || !Character.isUpperCase(text.charAt(0))) {
            return false;
        }
        GrExpression q = ref.getQualifierExpression();
        while (q != null) {
            if (!(q instanceof GrReferenceExpression)) {
                return false;
            }
            nameElement = ((GrReferenceExpression)q).getReferenceNameElement();
            if (!PsiImplUtil.isLeafElementOfType((PsiElement)nameElement, (IElementType)GroovyTokenTypes.mIDENT)) {
                return false;
            }
            q = ((GrReferenceExpression)q).getQualifierExpression();
        }
        return true;
    }

    @Nullable
    public static Pair<String, GrReferenceExpression> getBeanDefinition(@NotNull GrMethodCallExpression methodCall) {
        if (methodCall == null) {
            GrailsResourceBeanExtractor.$$$reportNull$$$0(1);
        }
        if (!(methodCall.getParent() instanceof GrCodeBlock)) {
            return null;
        }
        String beanName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)methodCall);
        if (beanName == null) {
            return null;
        }
        GrExpression[] allArguments = PsiUtil.getAllArguments((GrCall)methodCall);
        if (allArguments.length == 0) {
            return null;
        }
        int classNameArgumentIndex = 0;
        if (allArguments[0] == null) {
            if (allArguments.length == 1) {
                return null;
            }
            classNameArgumentIndex = 1;
        }
        if (!GrailsResourceBeanExtractor.isLooksLikeClassReference(allArguments[classNameArgumentIndex])) {
            return null;
        }
        return Pair.create((Object)beanName, (Object)((GrReferenceExpression)allArguments[classNameArgumentIndex]));
    }

    private static void processBeanDefinitionClosure(final Map<String, BeanDescriptor> descriptorMap, @NotNull GrClosableBlock closure) {
        if (closure == null) {
            GrailsResourceBeanExtractor.$$$reportNull$$$0(2);
        }
        closure.acceptChildren((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
                Pair<String, GrReferenceExpression> pair;
                if (methodCallExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((pair = GrailsResourceBeanExtractor.getBeanDefinition(methodCallExpression)) != null) {
                    BeanDescriptor beanDescriptor = (BeanDescriptor)descriptorMap.get(pair.first);
                    if (beanDescriptor == null) {
                        beanDescriptor = new BeanDescriptor((String)pair.first);
                        descriptorMap.put((String)pair.first, beanDescriptor);
                    }
                    beanDescriptor.getReferences().add((GrReferenceExpression)pair.second);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "org/jetbrains/plugins/grails/spring/GrailsResourceBeanExtractor$1", "visitMethodCallExpression"));
            }
        });
    }

    private static List<BeanDescriptor> evaluateBeanDescriptorsFromResourcesGroovy(@NotNull GroovyFile file) {
        if (file == null) {
            GrailsResourceBeanExtractor.$$$reportNull$$$0(3);
        }
        HashMap<String, BeanDescriptor> descriptorMap = new HashMap<String, BeanDescriptor>();
        for (PsiElement e = file.getFirstChild(); e != null; e = e.getNextSibling()) {
            GrExpression lValue;
            GrExpression rValue;
            GrAssignmentExpression assign;
            GrExpression[] allArguments;
            String methodName;
            if (e instanceof GrMethodCallExpression && "beans".equals(methodName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)((GrMethodCall)e))) && (allArguments = PsiUtil.getAllArguments((GrCall)((GrCall)e))).length == 1 && allArguments[0] instanceof GrClosableBlock) {
                GrailsResourceBeanExtractor.processBeanDefinitionClosure(descriptorMap, (GrClosableBlock)allArguments[0]);
            }
            if (!(e instanceof GrAssignmentExpression) || (assign = (GrAssignmentExpression)e).isOperatorAssignment() || !((rValue = ((GrAssignmentExpression)e).getRValue()) instanceof GrClosableBlock) || !((lValue = ((GrAssignmentExpression)e).getLValue()) instanceof GrReferenceExpression) || !"beans".equals(lValue.getText())) continue;
            GrailsResourceBeanExtractor.processBeanDefinitionClosure(descriptorMap, (GrClosableBlock)rValue);
        }
        return new ArrayList<BeanDescriptor>(descriptorMap.values());
    }

    private static List<BeanDescriptor> evaluateBeansFromPluginClass(@NotNull GrTypeDefinition pluginClass) {
        GrClosableBlock closure;
        if (pluginClass == null) {
            GrailsResourceBeanExtractor.$$$reportNull$$$0(4);
        }
        if ((closure = GrailsResourceBeanExtractor.getInitializer(pluginClass)) == null) {
            return Collections.emptyList();
        }
        HashMap<String, BeanDescriptor> descriptorMap = new HashMap<String, BeanDescriptor>();
        GrailsResourceBeanExtractor.processBeanDefinitionClosure(descriptorMap, closure);
        return new ArrayList<BeanDescriptor>(descriptorMap.values());
    }

    private static GrClosableBlock getInitializer(@NotNull GrTypeDefinition pluginClass) {
        GrStatement statement;
        GrStatement[] statements;
        GrOpenBlock block;
        PsiMethod method;
        GrExpression initializer;
        PsiField field;
        if (pluginClass == null) {
            GrailsResourceBeanExtractor.$$$reportNull$$$0(5);
        }
        if ((field = pluginClass.findCodeFieldByName("doWithSpring", false)) instanceof GrField && (initializer = ((GrField)field).getInitializerGroovy()) instanceof GrClosableBlock) {
            return (GrClosableBlock)initializer;
        }
        PsiMethod[] methods = pluginClass.findCodeMethodsByName("doWithSpring", false);
        if (methods.length == 1 && (method = methods[0]) instanceof GrMethod && (block = ((GrMethod)method).getBlock()) != null && (statements = block.getStatements()).length == 1 && (statement = statements[0]) instanceof GrClosableBlock) {
            return (GrClosableBlock)statement;
        }
        return null;
    }

    public static List<BeanDescriptor> getBeanDescriptorsFromResourcesGroovy(@NotNull GroovyFile file) {
        if (file == null) {
            GrailsResourceBeanExtractor.$$$reportNull$$$0(6);
        }
        return (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(GrailsResourceBeanExtractor.evaluateBeanDescriptorsFromResourcesGroovy(file), (Object[])new Object[]{file}));
    }

    public static List<BeanDescriptor> getBeanDescriptorsFromPluginClass(@NotNull GrTypeDefinition pluginClass) {
        if (pluginClass == null) {
            GrailsResourceBeanExtractor.$$$reportNull$$$0(7);
        }
        return (List)CachedValuesManager.getCachedValue((PsiElement)pluginClass, () -> CachedValueProvider.Result.create(GrailsResourceBeanExtractor.evaluateBeansFromPluginClass(pluginClass), (Object[])new Object[]{pluginClass}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/spring/GrailsResourceBeanExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLooksLikeClassReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBeanDefinition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processBeanDefinitionClosure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateBeanDescriptorsFromResourcesGroovy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateBeansFromPluginClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInitializer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBeanDescriptorsFromResourcesGroovy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getBeanDescriptorsFromPluginClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BeanDescriptor {
        private final String myName;
        private final List<GrReferenceExpression> myReferences = new ArrayList<GrReferenceExpression>();

        public BeanDescriptor(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        public List<GrReferenceExpression> getReferences() {
            return this.myReferences;
        }

        @Nullable
        public PsiType getType() {
            PsiManager manager = this.myReferences.get(0).getManager();
            PsiType res = null;
            for (GrReferenceExpression reference : this.myReferences) {
                PsiElement resolve = reference.resolve();
                if (!(resolve instanceof PsiClass)) continue;
                res = TypesUtil.getLeastUpperBoundNullable(res, (PsiType)PsiTypesUtil.getClassType((PsiClass)((PsiClass)resolve)), (PsiManager)manager);
            }
            return res;
        }
    }
}

