/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationExtension;
import org.jetbrains.plugins.grails.runner.SetupKt;
import org.jetbrains.plugins.grails.runner.impl.BaseGrailsCommandLineState;
import org.jetbrains.plugins.grails.structure.Grails3Application;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.springloaded.SpringLoadedPositionManagerFactory;

public class GrailsCommandLineState
extends BaseGrailsCommandLineState {
    @NotNull
    private final GrailsApplication myApplication;
    @NotNull
    private final MvcCommand myCommand;
    @NotNull
    private final GrailsCommandLineExecutor myExecutor;

    public GrailsCommandLineState(@NotNull ExecutionEnvironment environment, @NotNull GrailsRunConfiguration configuration, @NotNull GrailsCommandLineExecutor executor) throws ExecutionException {
        if (environment == null) {
            GrailsCommandLineState.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            GrailsCommandLineState.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            GrailsCommandLineState.$$$reportNull$$$0(2);
        }
        super(environment, configuration);
        this.myApplication = configuration.getGrailsApplication();
        this.myCommand = configuration.getGrailsCommand();
        this.myExecutor = executor;
    }

    @NotNull
    public GrailsApplication getApplication() {
        GrailsApplication grailsApplication2 = this.myApplication;
        if (grailsApplication2 == null) {
            GrailsCommandLineState.$$$reportNull$$$0(3);
        }
        return grailsApplication2;
    }

    @NotNull
    public MvcCommand getCommand() {
        MvcCommand mvcCommand = this.myCommand;
        if (mvcCommand == null) {
            GrailsCommandLineState.$$$reportNull$$$0(4);
        }
        return mvcCommand;
    }

    @NotNull
    public GrailsCommandLineExecutor getExecutor() {
        GrailsCommandLineExecutor grailsCommandLineExecutor = this.myExecutor;
        if (grailsCommandLineExecutor == null) {
            GrailsCommandLineState.$$$reportNull$$$0(5);
        }
        return grailsCommandLineExecutor;
    }

    @NotNull
    protected JavaParameters createJavaParameters() throws ExecutionException {
        MvcCommand command = this.getCommand();
        JavaParameters parameters = this.doCreateJavaParameters(command);
        parameters.setWorkingDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)this.getApplication().getRoot()));
        if (parameters.getJdk() == null) {
            Sdk sdk = ProjectRootManager.getInstance((Project)this.getEnvironment().getProject()).getProjectSdk();
            parameters.setJdk(sdk);
        }
        parameters.setEnv(new HashMap(command.getEnvVariables()));
        parameters.setPassParentEnvs(command.isPassParentEnvs());
        if (DefaultDebugExecutor.getDebugExecutorInstance().equals(this.getEnvironment().getExecutor())) {
            Version version = this.getApplication().getGrailsVersion();
            if (version.isAtLeast(Version.GRAILS_1_3_4) && version.isLessThan(Version.GRAILS_3_0) && !parameters.getEnv().containsKey("GROOVY_PAGE_ADD_LINE_NUMBERS")) {
                parameters.getEnv().put("GROOVY_PAGE_ADD_LINE_NUMBERS", "true");
            }
            if (version.compareTo(Version.GRAILS_2_0) >= 0 && !parameters.getVMParametersList().hasProperty("grails.full.stacktrace")) {
                parameters.getVMParametersList().addProperty("grails.full.stacktrace", "true");
            }
        }
        SetupKt.setupJavaParameters(this.getConfiguration(), this, parameters);
        JavaParameters javaParameters = parameters;
        if (javaParameters == null) {
            GrailsCommandLineState.$$$reportNull$$$0(6);
        }
        return javaParameters;
    }

    @NotNull
    protected JavaParameters doCreateJavaParameters(@NotNull MvcCommand command) throws ExecutionException {
        GrailsCommandLineExecutor executor;
        if (command == null) {
            GrailsCommandLineState.$$$reportNull$$$0(7);
        }
        if ((executor = this.getExecutor()) instanceof GrailsRunConfigurationExtension) {
            GrailsRunConfigurationExtension runConfigurationExtensionExecutor = (GrailsRunConfigurationExtension)((Object)executor);
            Key key = runConfigurationExtensionExecutor.getKey();
            JavaParameters javaParameters = runConfigurationExtensionExecutor.createJavaParameters(this.getApplication(), command, this.getConfiguration().getUserData(key));
            if (javaParameters == null) {
                GrailsCommandLineState.$$$reportNull$$$0(8);
            }
            return javaParameters;
        }
        JavaParameters javaParameters = executor.createJavaParameters(this.getApplication(), command);
        if (javaParameters == null) {
            GrailsCommandLineState.$$$reportNull$$$0(9);
        }
        return javaParameters;
    }

    @Override
    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler handler = super.startProcess();
        if (this.getApplication() instanceof Grails3Application) {
            handler.putUserData(SpringLoadedPositionManagerFactory.FORCE_SPRINGLOADED, (Object)true);
        }
        OSProcessHandler oSProcessHandler = handler;
        if (oSProcessHandler == null) {
            GrailsCommandLineState.$$$reportNull$$$0(10);
        }
        return oSProcessHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplication";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaParameters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateJavaParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCreateJavaParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

