/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationType;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

final class GrailsScriptRunConfigurationProducer
extends LazyRunConfigurationProducer<GrailsRunConfiguration> {
    GrailsScriptRunConfigurationProducer() {
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GrailsRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            GrailsScriptRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull GrailsRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        GrailsApplication application;
        if (configuration == null) {
            GrailsScriptRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GrailsScriptRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            GrailsScriptRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((application = GrailsActionUtilKt.getGrailsApplication(context.getDataContext())) == null) {
            return false;
        }
        PsiElement element = context.getPsiLocation();
        if (!(element instanceof GroovyFile)) {
            return false;
        }
        GroovyFile file = (GroovyFile)element;
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile scriptDir = GrailsScriptRunConfigurationProducer.getScriptsDirectory(application);
        if (scriptDir == null || !scriptDir.equals(virtualFile.getParent())) {
            return false;
        }
        if (!file.isScript() || !MvcFramework.isScriptFileName((String)virtualFile.getName())) {
            return false;
        }
        String scriptName = virtualFile.getNameWithoutExtension();
        configuration.setProgramParameters(GroovyNamesUtil.camelToSnake((String)scriptName));
        configuration.setGrailsApplication(application);
        configuration.setName("Grails: " + scriptName);
        sourceElement.set((Object)file);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull GrailsRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement element;
        if (configuration == null) {
            GrailsScriptRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GrailsScriptRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (!((element = context.getPsiLocation()) instanceof GroovyFile)) {
            return false;
        }
        GrailsRunConfiguration fromContext = (GrailsRunConfiguration)configuration.clone();
        if (this.setupConfigurationFromContext(fromContext, context, (Ref<PsiElement>)new Ref((Object)element))) {
            return Objects.equals(configuration.getProgramParameters(), fromContext.getProgramParameters()) && Comparing.equal((Object)configuration.getGrailsApplicationNullable(), (Object)fromContext.getGrailsApplicationNullable());
        }
        return false;
    }

    @Nullable
    public static VirtualFile getScriptsDirectory(@NotNull GrailsApplication application) {
        if (application == null) {
            GrailsScriptRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        return application.getGrailsVersion().isAtLeast(Version.GRAILS_3_0) ? VfsUtil.findRelativeFile((VirtualFile)application.getRoot(), (String[])new String[]{"src", "main", "scripts"}) : VfsUtil.findRelativeFile((VirtualFile)application.getRoot(), (String[])new String[]{"scripts"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/runner/GrailsScriptRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/runner/GrailsScriptRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getScriptsDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

