/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.tagSupport;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.tagSupport.TagAttributeReferenceProvider;
import org.jetbrains.plugins.grails.util.SafeReference;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GspFieldValueTagSupport
extends TagAttributeReferenceProvider {
    private static final Key<Pair<PsiReference[], Long>> ourCacheKey = Key.create((String)GspFieldValueTagSupport.class.getName());

    public GspFieldValueTagSupport() {
        super("field", "g", new String[]{"fieldValue", "fieldError", "hasErrors", "eachError"});
    }

    @Override
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull String text, int offset, @NotNull GspTagWrapper gspTagWrapper) {
        if (element == null) {
            GspFieldValueTagSupport.$$$reportNull$$$0(0);
        }
        if (text == null) {
            GspFieldValueTagSupport.$$$reportNull$$$0(1);
        }
        if (gspTagWrapper == null) {
            GspFieldValueTagSupport.$$$reportNull$$$0(2);
        }
        PsiFile file = element.getContainingFile();
        long modCount = file.getManager().getModificationTracker().getModificationCount() + (file.isPhysical() ? 0L : file.getModificationStamp());
        Pair cached = (Pair)element.getUserData(ourCacheKey);
        if (cached == null || (Long)cached.second != modCount) {
            cached = (Pair)((UserDataHolderEx)element).putUserDataIfAbsent(ourCacheKey, (Object)Pair.create((Object)GspFieldValueTagSupport.createFieldReferences(element, text, offset, gspTagWrapper), (Object)modCount));
        }
        PsiReference[] psiReferenceArray = (PsiReference[])((PsiReference[])cached.first).clone();
        if (psiReferenceArray == null) {
            GspFieldValueTagSupport.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static PsiReference[] createFieldReferences(PsiElement element, String text, int offset, GspTagWrapper gspTagWrapper) {
        PsiClass aClass;
        PsiType beanType = gspTagWrapper.getAttributeValueType("bean");
        if (beanType == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiType type = beanType;
        ArrayList<FieldReference> res = new ArrayList<FieldReference>();
        int i2 = 0;
        while ((aClass = PsiTypesUtil.getPsiClass((PsiType)type)) != null) {
            int i22 = text.indexOf(46, i2);
            if (i22 == -1) {
                i22 = text.length();
            }
            String fieldName = text.substring(i2, i22);
            PsiMethod getter = GroovyPropertyUtils.findPropertyGetter((PsiClass)aClass, (String)fieldName, null, (boolean)true);
            FieldReference fieldRef = new FieldReference(element, TextRange.from((int)(offset + i2), (int)(i22 - i2)), aClass, getter);
            res.add(fieldRef);
            if (getter instanceof GrMethod) {
                type = ((GrMethod)getter).getInferredReturnType();
            } else {
                if (getter == null) break;
                type = getter.getReturnType();
            }
            if (i22 == text.length()) break;
            i2 = i22 + 1;
        }
        PsiReference[] resArray = res.toArray(PsiReference.EMPTY_ARRAY);
        SafeReference.makeReferencesSafe(resArray);
        return resArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gspTagWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiClass myBeanClass;
        private final PsiMethod myGetter;

        protected FieldReference(PsiElement element, TextRange range, @NotNull PsiClass beanClass, @Nullable PsiMethod getter) {
            if (beanClass == null) {
                FieldReference.$$$reportNull$$$0(0);
            }
            super(element, range, true);
            this.myBeanClass = beanClass;
            this.myGetter = getter;
        }

        public PsiElement resolve() {
            return this.myGetter;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                FieldReference.$$$reportNull$$$0(1);
            }
            if (!(this.myGetter instanceof GrAccessorMethod)) {
                String s2 = GroovyPropertyUtils.getPropertyNameByGetterName((String)newElementName, (boolean)PsiType.BOOLEAN.equals((Object)this.myGetter.getReturnType()));
                if (s2 == null) {
                    return this.getElement();
                }
                newElementName = s2;
            }
            TextRange rangeBefore = this.getRangeInElement();
            PsiElement result2 = super.handleElementRename(newElementName);
            this.setRangeInElement(TextRange.from((int)rangeBefore.getStartOffset(), (int)newElementName.length()));
            return result2;
        }

        public Object @NotNull [] getVariants() {
            Map propertyGetters = PropertyUtilBase.getAllProperties((PsiClass)this.myBeanClass, (boolean)false, (boolean)true);
            Object[] res = new Object[propertyGetters.size()];
            int i2 = 0;
            for (Map.Entry entry : propertyGetters.entrySet()) {
                PsiMethod getter = (PsiMethod)entry.getValue();
                res[i2++] = CompleteReferenceExpression.createPropertyLookupElement((PsiMethod)getter, null, null);
            }
            if (res == null) {
                FieldReference.$$$reportNull$$$0(2);
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beanClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport$FieldReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport$FieldReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

