/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.DomainMembersProvider;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameGrFieldProcessor;

public class DomainFieldRenameProcessor
extends RenameGrFieldProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            DomainFieldRenameProcessor.$$$reportNull$$$0(0);
        }
        if (!(element instanceof GrField)) {
            return false;
        }
        GrField field = (GrField)element;
        PsiClass domainClass = field.getContainingClass();
        if (!GormUtils.isGormBean(domainClass)) {
            return false;
        }
        assert (domainClass != null);
        return DomainDescriptor.getPersistentProperties(domainClass).containsKey(field.getName());
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            DomainFieldRenameProcessor.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            DomainFieldRenameProcessor.$$$reportNull$$$0(2);
        }
        final ArrayList<PsiReference> res = new ArrayList<PsiReference>(super.findReferences(element, searchScope, searchInCommentsAndStrings));
        final GrField field = (GrField)element;
        PsiClass domainClass = field.getContainingClass();
        assert (domainClass != null);
        String name = field.getName();
        assert (name != null);
        final String capName = StringUtil.capitalize((String)name);
        SearchScope useScope = domainClass.getUseScope().intersectWith(searchScope);
        DomainDescriptor descriptor = DomainDescriptor.getDescriptor(domainClass);
        if (descriptor.getHasMany().containsKey(name)) {
            for (PsiMethod method : descriptor.getAddToAndRemoveFromMethods()) {
                String methodName = method.getName();
                if (!methodName.endsWith(capName)) continue;
                for (PsiReference reference : ReferencesSearch.search((PsiElement)method, (SearchScope)useScope).findAll()) {
                    GrReferenceExpression grRef;
                    PsiElement nameElement;
                    if (!(reference instanceof GrReferenceExpression) || (nameElement = (grRef = (GrReferenceExpression)reference).getReferenceNameElement()) == null || !methodName.equals(nameElement.getText())) continue;
                    TextRange range = TextRange.from((int)(nameElement.getStartOffsetInParent() + methodName.length() - capName.length()), (int)capName.length());
                    res.add((PsiReference)new FinderMethodFieldReference(grRef, range, field));
                }
            }
        }
        ReferencesSearch.search((PsiElement)domainClass, (SearchScope)useScope, (boolean)false).forEach((Processor)new Processor<PsiReference>(){

            private void processReference(PsiReference psiReference) {
                if (!(psiReference instanceof GrReferenceExpression)) {
                    return;
                }
                PsiElement parent = ((GrReferenceExpression)psiReference).getParent();
                if (!(parent instanceof GrReferenceExpression)) {
                    return;
                }
                PsiElement methodCall = parent.getParent();
                if (!(methodCall instanceof GrMethodCall)) {
                    return;
                }
                GrReferenceExpression parentRef = (GrReferenceExpression)parent;
                if (parentRef.getDotTokenType() != GroovyTokenTypes.mDOT) {
                    return;
                }
                DomainClassUtils.FinderMethod finderMethod = DomainClassUtils.parseFinderMethod(parentRef.getReferenceName());
                if (finderMethod == null) {
                    return;
                }
                boolean hasProperty = false;
                for (DomainClassUtils.Condition condition : finderMethod.getConditions()) {
                    if (!condition.getFieldName().equals(capName)) continue;
                    hasProperty = true;
                    break;
                }
                if (!hasProperty) {
                    return;
                }
                PsiMethod method = ((GrMethodCall)methodCall).resolveMethod();
                if (!GrLightMethodBuilder.checkKind((PsiElement)method, (Object)DomainMembersProvider.FINDER_METHOD_MARKER)) {
                    return;
                }
                PsiElement nameElement = parentRef.getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                int i2 = finderMethod.getPrefix().length();
                for (DomainClassUtils.Condition condition : finderMethod.getConditions()) {
                    if (!condition.getFieldName().equals(capName)) continue;
                    res.add(new FinderMethodFieldReference(parentRef, TextRange.from((int)(nameElement.getStartOffsetInParent() + i2), (int)capName.length()), field));
                    i2 += condition.getLength();
                    if (finderMethod.getOperator() == null) continue;
                    i2 += finderMethod.getOperator().length();
                }
            }

            public boolean process(PsiReference psiReference) {
                this.processReference(psiReference);
                return true;
            }
        });
        ArrayList<PsiReference> arrayList = res;
        if (arrayList == null) {
            DomainFieldRenameProcessor.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void renameElement(@NotNull PsiElement psiElement, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (psiElement == null) {
            DomainFieldRenameProcessor.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            DomainFieldRenameProcessor.$$$reportNull$$$0(5);
        }
        if (usages == null) {
            DomainFieldRenameProcessor.$$$reportNull$$$0(6);
        }
        ArrayList<UsageInfo> usagesList = new ArrayList<UsageInfo>(usages.length);
        for (UsageInfo usage : usages) {
            PsiReference psiReference = usage.getReference();
            if (psiReference instanceof FinderMethodFieldReference) {
                GrReferenceExpression ref = (GrReferenceExpression)psiReference.getElement();
                PsiField field = (PsiField)psiReference.resolve();
                assert (field != null);
                String oldCapName = StringUtil.capitalize((String)field.getName());
                String newCapName = StringUtil.capitalize((String)newName);
                String oldMethodName = ref.getReferenceName();
                assert (oldMethodName != null);
                if (DomainFieldRenameProcessor.isAddToOrRemoveFromName(oldMethodName, oldCapName)) {
                    ref.handleElementRename(oldMethodName.substring(0, oldMethodName.length() - oldCapName.length()) + newCapName);
                    continue;
                }
                DomainClassUtils.FinderMethod finderMethod = DomainClassUtils.parseFinderMethod(oldMethodName);
                if (finderMethod == null) continue;
                for (DomainClassUtils.Condition condition : finderMethod.getConditions()) {
                    if (!condition.getFieldName().equals(oldCapName)) continue;
                    condition.setFieldName(newCapName);
                }
                ref.handleElementRename(finderMethod.toString());
                continue;
            }
            usagesList.add(usage);
        }
        super.renameElement(psiElement, newName, usagesList.size() == usages.length ? usages : usagesList.toArray(UsageInfo.EMPTY_ARRAY), listener);
    }

    private static boolean isAddToOrRemoveFromName(String methodName, String capName) {
        return DomainFieldRenameProcessor.stringEquals(methodName, "addTo", capName) || DomainFieldRenameProcessor.stringEquals(methodName, "removeFrom", capName);
    }

    private static boolean stringEquals(String s2, String prefix, String suffix) {
        return s2.length() == prefix.length() + suffix.length() && s2.startsWith(prefix) && s2.endsWith(suffix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/domain/DomainFieldRenameProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/domain/DomainFieldRenameProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FinderMethodFieldReference
    extends PsiReferenceBase<PsiElement> {
        private final GrField myField;

        FinderMethodFieldReference(GrReferenceExpression refExpr, TextRange range, GrField field) {
            super((PsiElement)refExpr, range);
            this.myField = field;
        }

        public PsiElement resolve() {
            return this.myField;
        }
    }
}

