/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.controller;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GrMapAttributeValue;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspOuterHtmlElement;
import org.jetbrains.plugins.grails.references.controller.ActionReference;
import org.jetbrains.plugins.grails.references.controller.ControllerReference;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ControllerReferenceProvider
extends PsiReferenceProvider {
    private static final List<String> CONTROLLER_METHODS = Arrays.asList("chain", "forward", "redirect", "render");
    private static final Pattern URL_ATTR_PATTERN = Pattern.compile(".*\\s+url\\s*=\\s*['\"]", 32);
    private static final Map<String, Collection<String>> METHODS_WITH_PARAMETER_CONTROLLERACTION = GrailsUtils.createMap("subflow", Collections.singleton("org.codehaus.groovy.grails.webflow.engine.builder.FlowInfoCapturer"), "render", Collections.singleton("org.codehaus.groovy.grails.webflow.engine.builder.FlowInfoCapturer"), "redirect", Collections.singleton("org.codehaus.groovy.grails.webflow.engine.builder.FlowInfoCapturer"), "link", Collections.singleton("org.codehaus.groovy.grails.web.mapping.LinkGenerator"));

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Object ref;
        PsiElement p;
        if (element == null) {
            ControllerReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ControllerReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((p = element.getParent()) instanceof GrConditionalExpression) {
            if (((GrConditionalExpression)p).getCondition() == p) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    ControllerReferenceProvider.$$$reportNull$$$0(2);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            p = p.getParent();
        }
        if (!(p instanceof GrNamedArgument)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ControllerReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GrNamedArgument namedArgument = (GrNamedArgument)p;
        GrArgumentLabel label = namedArgument.getLabel();
        if (label == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ControllerReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String key = label.getName();
        boolean isAction = "action".equals(key);
        if (!isAction && !"controller".equals(key)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ControllerReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement arguments = namedArgument.getParent();
        if (arguments instanceof GrListOrMap) {
            PsiElement parent = arguments.getParent();
            if (parent instanceof GrMapAttributeValue) {
                Object ref2;
                PsiElement prev = parent.getPrevSibling();
                if (!(prev instanceof GspOuterHtmlElement) || !URL_ATTR_PATTERN.matcher(prev.getText()).matches()) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        ControllerReferenceProvider.$$$reportNull$$$0(6);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                if (isAction) {
                    String controllerName = ControllerReferenceProvider.getNamedArgument(namedArgument, "controller");
                    if (controllerName == null) {
                        PsiFile psiFile = namedArgument.getContainingFile();
                        if (psiFile == null) {
                            if (PsiReference.EMPTY_ARRAY == null) {
                                ControllerReferenceProvider.$$$reportNull$$$0(7);
                            }
                            return PsiReference.EMPTY_ARRAY;
                        }
                        VirtualFile file = psiFile.getOriginalFile().getVirtualFile();
                        if (file == null) {
                            if (PsiReference.EMPTY_ARRAY == null) {
                                ControllerReferenceProvider.$$$reportNull$$$0(8);
                            }
                            return PsiReference.EMPTY_ARRAY;
                        }
                        controllerName = GrailsUtils.getControllerNameByGsp(file);
                        if (controllerName == null) {
                            if (PsiReference.EMPTY_ARRAY == null) {
                                ControllerReferenceProvider.$$$reportNull$$$0(9);
                            }
                            return PsiReference.EMPTY_ARRAY;
                        }
                    }
                    ref2 = new ActionReference(element, false, controllerName);
                } else {
                    ref2 = new ControllerReference(element, false);
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{ref2};
                if (psiReferenceArray == null) {
                    ControllerReferenceProvider.$$$reportNull$$$0(10);
                }
                return psiReferenceArray;
            }
            arguments = parent;
        }
        if (!(arguments instanceof GrArgumentList)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ControllerReferenceProvider.$$$reportNull$$$0(11);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement eMethodCall = arguments.getParent();
        if (!(eMethodCall instanceof GrMethodCall)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ControllerReferenceProvider.$$$reportNull$$$0(12);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (!ControllerReferenceProvider.isSupportActionController((GrMethodCall)eMethodCall)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ControllerReferenceProvider.$$$reportNull$$$0(13);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (isAction) {
            String controllerName = ControllerReferenceProvider.getNamedArgument(namedArgument, "controller");
            if (controllerName == null) {
                PsiClass artifactClass = PsiUtil.getContainingNotInnerClass((PsiElement)eMethodCall);
                GrailsArtifact artifact = GrailsArtifact.getType(artifactClass);
                if (artifact != GrailsArtifact.CONTROLLER) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        ControllerReferenceProvider.$$$reportNull$$$0(14);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                assert (artifactClass != null);
                controllerName = GrailsArtifact.CONTROLLER.getArtifactName(artifactClass);
            }
            ref = new ActionReference(element, false, controllerName);
        } else {
            ref = new ControllerReference(element, false);
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{ref};
        if (psiReferenceArray == null) {
            ControllerReferenceProvider.$$$reportNull$$$0(15);
        }
        return psiReferenceArray;
    }

    private static boolean isSupportActionController(GrMethodCall methodCall) {
        PsiMethod method;
        PsiClass artifactClass;
        GrailsArtifact artifact;
        PsiClass containingClass;
        PsiMethod method2;
        GrExpression invokedExpr = methodCall.getInvokedExpression();
        if (!(invokedExpr instanceof GrReferenceExpression)) {
            return false;
        }
        String methodName = ((GrReferenceExpression)invokedExpr).getReferenceName();
        Collection<String> classes = METHODS_WITH_PARAMETER_CONTROLLERACTION.get(methodName);
        if (classes != null && (method2 = methodCall.resolveMethod()) != null && (containingClass = method2.getContainingClass()) != null) {
            for (String aClass : classes) {
                if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)aClass)) continue;
                return true;
            }
        }
        return CONTROLLER_METHODS.contains(methodName) && ((artifact = GrailsArtifact.getType(artifactClass = PsiUtil.getContainingNotInnerClass((PsiElement)methodCall))) == GrailsArtifact.CONTROLLER || artifact == GrailsArtifact.FILTER) && (method = methodCall.resolveMethod()) instanceof LightElement;
    }

    @Nullable
    private static String getNamedArgument(GrNamedArgument oneNamedArgument, String argumentName) {
        Object value;
        PsiElement valueElement = PsiUtil.getNamedArgumentValue((GrNamedArgument)oneNamedArgument, (String)argumentName);
        if (valueElement == null) {
            return null;
        }
        if (valueElement instanceof GrLiteralImpl && (value = ((GrLiteral)valueElement).getValue()) instanceof String) {
            return (String)value;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/controller/ControllerReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/controller/ControllerReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

