/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.controller;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.Function;
import icons.JetgroovyIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class ActionReference
extends PsiReferenceBase<PsiElement>
implements Function<PsiElement, Map<String, PsiMethod>> {
    private final Function<? super PsiElement, ? extends Map<String, PsiMethod>> myControllerResolver;
    private final String myControllerName;
    private Map<String, PsiMethod> myActions;

    public ActionReference(PsiElement element, TextRange range, boolean soft, Function<? super PsiElement, ? extends Map<String, PsiMethod>> controllerResolver) {
        super(element, range, soft);
        TextRange textRange = this.trimExtension(range);
        this.setRangeInElement(textRange);
        this.myControllerResolver = controllerResolver;
        this.myControllerName = null;
    }

    public ActionReference(PsiElement element, boolean soft, Function<? super PsiElement, ? extends Map<String, PsiMethod>> controllerResolver) {
        super(element, soft);
        this.myControllerResolver = controllerResolver;
        this.myControllerName = null;
    }

    public ActionReference(PsiElement element, boolean soft, @NotNull String controllerName) {
        if (controllerName == null) {
            ActionReference.$$$reportNull$$$0(0);
        }
        super(element, soft);
        this.myControllerResolver = this;
        this.myControllerName = controllerName;
    }

    private TextRange trimExtension(TextRange defaultRange) {
        String elementText = this.getElement().getText();
        String value = defaultRange.substring(elementText);
        int dotIndex = value.lastIndexOf(46);
        if (dotIndex >= 0) {
            return TextRange.from((int)defaultRange.getStartOffset(), (int)dotIndex);
        }
        return defaultRange;
    }

    protected TextRange calculateDefaultRangeInElement() {
        TextRange defaultRange = super.calculateDefaultRangeInElement();
        defaultRange = this.trimExtension(defaultRange);
        return defaultRange;
    }

    public PsiElement resolve() {
        String value = this.getValue();
        if (value.isEmpty()) {
            return null;
        }
        return GrailsUtils.toField(this.getActions().get(value));
    }

    public static LookupElementBuilder[] createLookupItems(Collection<String> actionNames) {
        LookupElementBuilder[] res = new LookupElementBuilder[actionNames.size()];
        int i2 = 0;
        for (String actionName : actionNames) {
            res[i2++] = LookupElementBuilder.create((String)actionName).withIcon(JetgroovyIcons.Mvc.Action_method);
        }
        return res;
    }

    public Object @NotNull [] getVariants() {
        Object[] objectArray = ActionReference.createLookupItems(this.getActions().keySet());
        if (objectArray == null) {
            ActionReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private Map<String, PsiMethod> getActions() {
        Map res = this.myActions;
        if (res == null) {
            this.myActions = res = (Map)this.myControllerResolver.fun((Object)this.getElement());
        }
        return res;
    }

    @Nullable
    public String getControllerName() {
        return this.myControllerName;
    }

    public Map<String, PsiMethod> fun(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            return Collections.emptyMap();
        }
        return GrailsUtils.getControllerActions(this.myControllerName, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/controller/ActionReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/controller/ActionReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

