/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.util.CodecUtil;

public class CodecReference
extends PsiReferenceBase<PsiElement> {
    public CodecReference(PsiElement element, boolean soft) {
        super(element, soft);
    }

    public PsiElement resolve() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            return null;
        }
        String value = this.getValue();
        Couple<PsiMethod> pair = CodecUtil.getCodecMap(module).get(value);
        if (pair == null || pair.first == null) {
            return null;
        }
        return ((PsiMethod)pair.first).getNavigationElement();
    }

    public Object @NotNull [] getVariants() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                CodecReference.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Couple<PsiMethod>> entry : CodecUtil.getCodecMap(module).entrySet()) {
            if (entry.getValue().first == null) continue;
            res.add(entry.getKey());
        }
        Object[] objectArray = res.toArray();
        if (objectArray == null) {
            CodecReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/CodecReference", "getVariants"));
    }
}

