/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class ArtifactPropertyGetterReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public ArtifactPropertyGetterReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiMethod elementToSearch;
        if (queryParameters == null) {
            ArtifactPropertyGetterReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            ArtifactPropertyGetterReferenceSearcher.$$$reportNull$$$0(1);
        }
        if (!((elementToSearch = queryParameters.getMethod()) instanceof GrMethod)) {
            return;
        }
        GrMethod getter = (GrMethod)elementToSearch;
        if (!PropertyUtilBase.isSimplePropertyGetter((PsiMethod)getter)) {
            return;
        }
        ArtifactPropertyGetterReferenceSearcher.searchReferences((PsiMethod)getter, (PsiElement)getter, queryParameters.getEffectiveSearchScope(), queryParameters.getOptimizer());
    }

    static void searchReferences(@NotNull PsiMethod getter, PsiElement elementToSearch, @NotNull SearchScope scope, @NotNull SearchRequestCollector optimizer) {
        String fieldName;
        PsiClass psiClass;
        GrailsArtifact artifact;
        if (getter == null) {
            ArtifactPropertyGetterReferenceSearcher.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            ArtifactPropertyGetterReferenceSearcher.$$$reportNull$$$0(3);
        }
        if (optimizer == null) {
            ArtifactPropertyGetterReferenceSearcher.$$$reportNull$$$0(4);
        }
        if ((artifact = GrailsArtifact.getType(psiClass = getter.getContainingClass())) == null && GormUtils.isStandaloneGormBean(psiClass)) {
            artifact = GrailsArtifact.DOMAIN;
        }
        if (artifact != GrailsArtifact.CONTROLLER && artifact != GrailsArtifact.TAGLIB && artifact != GrailsArtifact.DOMAIN) {
            return;
        }
        String propertyName = GroovyPropertyUtils.getPropertyNameByGetterName((String)getter.getName(), (boolean)true);
        assert (propertyName != null);
        short searchContext = 0;
        if (artifact == GrailsArtifact.CONTROLLER || artifact == GrailsArtifact.DOMAIN) {
            searchContext = (short)(searchContext | 4);
        }
        if (elementToSearch instanceof GrField && (fieldName = ((GrField)elementToSearch).getName()) != null && !fieldName.equals(propertyName)) {
            searchContext = (short)(searchContext | 8);
        }
        if (searchContext == 0) {
            return;
        }
        if (scope instanceof GlobalSearchScope) {
            scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)scope), (FileType[])new FileType[]{GroovyFileType.GROOVY_FILE_TYPE, GspFileType.GSP_FILE_TYPE});
        }
        optimizer.searchWord(propertyName, scope, searchContext, true, elementToSearch);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/references/common/ArtifactPropertyGetterReferenceSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "searchReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

