/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.projectView.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.projectView.nodes.CompactedFqn;
import org.jetbrains.plugins.grails.projectView.nodes.GrailsArtefactPackageNode;
import org.jetbrains.plugins.grails.projectView.nodes.ImplKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0096\u0002J\u0016\u0010\u0016\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u000bj\u0002`\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/grails/projectView/nodes/GrailsRegularPackageNode;", "Lorg/jetbrains/plugins/grails/projectView/nodes/GrailsArtefactPackageNode;", "Lorg/jetbrains/plugins/grails/projectView/nodes/CompactedFqn;", "Lcom/intellij/ide/util/treeView/ValidateableNode;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "fqns", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/projectView/ViewSettings;Lorg/jetbrains/plugins/grails/projectView/nodes/CompactedFqn;)V", "nodeDirectories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getNodeDirectories", "()Ljava/util/Collection;", "packageFqn", "", "getPackageFqn", "()Ljava/lang/String;", "contains", "", "file", "getChildren", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lorg/jetbrains/plugins/grails/projectView/nodes/TreeNodes;", "isValid", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.groovy.grails"})
public final class GrailsRegularPackageNode
extends GrailsArtefactPackageNode<CompactedFqn>
implements ValidateableNode {
    @Override
    @NotNull
    public String getPackageFqn() {
        return ((CompactedFqn)this.getValue()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValid() {
        CompactedFqn value = (CompactedFqn)this.getValue();
        if (value.getHasCompactedFqns()) {
            ViewSettings viewSettings = this.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)viewSettings, (String)"settings");
            if (viewSettings.isHideEmptyMiddlePackages()) {
                void baseFqn;
                CompactedFqn compactedFqn = value;
                List<String> list = compactedFqn.component1();
                List<String> relativeParts = compactedFqn.component2();
                Collection<List<String>> newPackages = ImplKt.getPackagesRegular(this.getArtefacts(), (List<String>)baseFqn, true);
                return newPackages.contains(relativeParts);
            }
        }
        return true;
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        presentation.setPresentableText(ImplKt.fqnString(((CompactedFqn)this.getValue()).getRelativeParts()));
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        Collection<PsiClass> collection = this.getArtefacts();
        Project project = this.getProject();
        Intrinsics.checkNotNull((Object)project);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project!!");
        ViewSettings viewSettings = this.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)viewSettings, (String)"settings");
        return ImplKt.getNodesRegular(collection, project, viewSettings, this.getArtefactHandler(), ((CompactedFqn)this.getValue()).getAllParts());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Collection<VirtualFile> getNodeDirectories() {
        void $this$flatMapTo$iv;
        Iterable iterable = ((CompactedFqn)this.getValue()).getExpandedFqns();
        Collection collection = new HashSet();
        GrailsRegularPackageNode grailsRegularPackageNode = this;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void destination$iv;
            String p1 = (String)element$iv;
            boolean bl = false;
            Iterable list$iv = grailsRegularPackageNode.packageDirectories(p1);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return collection;
    }

    public boolean contains(@NotNull VirtualFile file) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$any$iv = this.packageDirectories((String)CollectionsKt.first(((CompactedFqn)this.getValue()).getExpandedFqns()));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public GrailsRegularPackageNode(@NotNull Project project, @NotNull ViewSettings settings, @NotNull CompactedFqn fqns) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)fqns, (String)"fqns");
        super(project, settings, fqns);
    }
}

