/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.maven;

import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.util.GrailsFacetProvider;

public final class GrailsMavenImporter
extends MavenImporter {
    private static final Set<String> IMPORTED_ARTIFACT_GROUPS = Set.of("javax.servlet", "org.grails");

    public GrailsMavenImporter() {
        super("org.grails", "grails-maven-plugin");
    }

    public void resolve(Project project, MavenProject mavenProject, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder, ResolveContext context) throws MavenProcessCanceledException {
        for (MavenArtifact artifact : mavenProject.getDependencies()) {
            if (!"runtime".equals(artifact.getScope())) continue;
            artifact.setScope("compile");
        }
        MavenPlugin plugin = mavenProject.findPlugin(this.myPluginGroupID, this.myPluginArtifactID);
        if (plugin == null) {
            return;
        }
        THashSet projectDeps = new THashSet();
        for (MavenArtifact dep : mavenProject.getDependencies()) {
            projectDeps.add(dep.getMavenId());
        }
        Collection pluginDeps = embedder.resolvePlugin(plugin, mavenProject.getRemoteRepositories(), nativeMavenProject, true);
        for (MavenArtifact each : pluginDeps) {
            MavenArtifact projectDependency;
            List list;
            if (this.myPluginGroupID.equals(each.getGroupId()) && this.myPluginArtifactID.equals(each.getArtifactId())) continue;
            if (IMPORTED_ARTIFACT_GROUPS.contains(each.getGroupId()) && projectDeps.add(each.getMavenId())) {
                each.setScope("compile");
                mavenProject.addDependency(each);
            }
            if ((list = mavenProject.findDependencies(each.getGroupId(), each.getArtifactId())).size() != 1 || (projectDependency = (MavenArtifact)list.get(0)).getVersion().equals(each.getVersion()) || !projectDependency.getMavenId().equals("org.slf4j", "slf4j-api")) continue;
            each.setScope("compile");
            mavenProject.addDependency(each);
        }
    }

    public void preProcess(Module module, MavenProject mavenProject, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
    }

    /*
     * WARNING - void declaration
     */
    public void process(IdeModifiableModelsProvider modifiableModelsProvider, Module module, MavenRootModelAdapter rootModel, MavenProjectsTree mavenModel, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        void var12_14;
        ArrayList<Consumer<ModifiableFacetModel>> actions = new ArrayList<Consumer<ModifiableFacetModel>>();
        GrailsFacetProvider[] grailsFacetProviderArray = (GrailsFacetProvider[])GrailsFacetProvider.EP_NAME.getExtensions();
        int n = grailsFacetProviderArray.length;
        boolean bl = false;
        while (var12_14 < n) {
            GrailsFacetProvider provider = grailsFacetProviderArray[var12_14];
            provider.addFacets(actions, module, Collections.singletonList(mavenProject.getDirectoryFile()));
            ++var12_14;
        }
        ModifiableFacetModel model = modifiableModelsProvider.getModifiableFacetModel(module);
        for (Consumer consumer : actions) {
            consumer.consume((Object)model);
        }
    }

    public void collectSourceRoots(MavenProject mavenProject, PairConsumer<String, JpsModuleSourceRootType<?>> result2) {
        for (Map.Entry entry : GrailsFramework.GRAILS_SOURCE_FOLDERS.entrySet()) {
            JpsModuleSourceRootType type = (JpsModuleSourceRootType)entry.getKey();
            for (String path : (Collection)entry.getValue()) {
                result2.consume((Object)path, (Object)type);
            }
        }
    }
}

