/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.maven;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaProgramPatcher;
import com.intellij.execution.ui.RunContentDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.maven.GrailsMavenApplication;
import org.jetbrains.plugins.grails.maven.MavenCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.impl.GrailsCommandLineState;
import org.jetbrains.plugins.grails.runner.util.GrailsExecutionUtils;
import org.jetbrains.plugins.grails.util.GrailsUtils;

final class GrailsMavenDebuggerRunner
extends GenericDebuggerRunner {
    GrailsMavenDebuggerRunner() {
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            GrailsMavenDebuggerRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            GrailsMavenDebuggerRunner.$$$reportNull$$$0(1);
        }
        if (profile instanceof GrailsRunConfiguration && "Debug".equals(executorId)) {
            return ((GrailsRunConfiguration)profile).getGrailsApplicationNullable() instanceof GrailsMavenApplication;
        }
        return false;
    }

    @NotNull
    public String getRunnerId() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            GrailsMavenDebuggerRunner.$$$reportNull$$$0(2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        ServerSocket serverSocket;
        File tmpFile;
        if (state == null) {
            GrailsMavenDebuggerRunner.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            GrailsMavenDebuggerRunner.$$$reportNull$$$0(4);
        }
        if (!(state instanceof GrailsCommandLineState) || !(((GrailsCommandLineState)state).getExecutor() instanceof MavenCommandExecutor)) {
            return super.createContentDescriptor(state, environment);
        }
        try {
            tmpFile = File.createTempFile("grailsStartFlag", "");
        }
        catch (IOException e) {
            throw new ExecutionException(GrailsBundle.message("dialog.message.failed.to.create.temp.file", new Object[0]), (Throwable)e);
        }
        tmpFile.deleteOnExit();
        JavaParameters parameters = ((JavaCommandLine)state).getJavaParameters();
        GrailsExecutionUtils.addAgentJar(parameters);
        GrailsUtils.addSystemPropertyIfNotExists(parameters.getVMParametersList(), "-DforkDebug=true");
        JavaProgramPatcher.runCustomPatchers((JavaParameters)parameters, (Executor)environment.getExecutor(), (RunProfile)environment.getRunProfile());
        RemoteConnection connection2 = new RemoteConnectionBuilder(false, 0, "").asyncAgent(true).project(environment.getProject()).memoryAgent(DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT).create(parameters);
        parameters.getVMParametersList().addProperty("idea.grails.kind.file", tmpFile.getAbsolutePath());
        RemoteConnection c2 = new RemoteConnection(true, "127.0.0.1", DebuggerUtils.getInstance().findAvailableDebugAddress(true), false);
        try {
            serverSocket = new ServerSocket(Integer.parseInt(c2.getDebuggerAddress()));
        }
        catch (IOException e) {
            throw new ExecutionException(GrailsBundle.message("dialog.message.failed.to.open.server.socket", new Object[0]), (Throwable)e);
        }
        try {
            RunContentDescriptor descriptor = this.attachVirtualMachine(state, environment, c2, true);
            try {
                SocketThread socketThread = new SocketThread(serverSocket.accept(), tmpFile, descriptor.getProcessHandler(), Integer.parseInt(connection2.getDebuggerAddress()));
                Thread t = new Thread((Runnable)socketThread, "grails socket thread");
                t.setDaemon(true);
                t.start();
            }
            catch (IOException e) {
                throw new ExecutionException(GrailsBundle.message("dialog.message.failed.to.open.server.socket", new Object[0]), (Throwable)e);
            }
            RunContentDescriptor runContentDescriptor = descriptor;
            return runContentDescriptor;
        }
        finally {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/maven/GrailsMavenDebuggerRunner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/maven/GrailsMavenDebuggerRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createContentDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SocketThread
    implements Runnable {
        private final Socket mySocket;
        private final File myFile;
        private final ProcessHandler myProcessHandler;
        private final int myMavenProcessPort;

        private SocketThread(Socket socket, File file, ProcessHandler processHandler, int mavenProcessPort) {
            this.mySocket = socket;
            this.myFile = file;
            this.myProcessHandler = processHandler;
            this.myMavenProcessPort = mavenProcessPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int debugPort;
                while (true) {
                    if (this.myProcessHandler.isProcessTerminated()) {
                        return;
                    }
                    long length = this.myFile.length();
                    if (length != 0L) {
                        this.myFile.delete();
                        if (length == 1L) {
                            debugPort = this.myMavenProcessPort;
                            break;
                        }
                        debugPort = 5005;
                        Thread.sleep(1000L);
                        break;
                    }
                    Thread.sleep(300L);
                }
                try (Socket debuggedProcessSocket = new Socket("127.0.0.1", debugPort);){
                    Thread t = new Thread(() -> {
                        try {
                            SocketThread.copyStream(this.mySocket.getInputStream(), debuggedProcessSocket.getOutputStream());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }, "copy stream");
                    t.setDaemon(true);
                    t.start();
                    SocketThread.copyStream(debuggedProcessSocket.getInputStream(), this.mySocket.getOutputStream());
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                try {
                    this.mySocket.close();
                }
                catch (IOException iOException) {}
            }
        }

        private static void copyStream(InputStream in, OutputStream out) throws IOException {
            int length;
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
    }
}

