/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.gspIndex;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringSearcher;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.gspIndex.GspIncludeInfo;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspOuterGroovyElement;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GspIncludeIndex
extends FileBasedIndexExtension<String, Collection<GspIncludeInfo>>
implements DataIndexer<String, Collection<GspIncludeInfo>, FileContent>,
DataExternalizer<Collection<GspIncludeInfo>>,
FileBasedIndex.FileTypeSpecificInputFilter {
    public static final ID<String, Collection<GspIncludeInfo>> NAME = ID.create((String)"GspIncludeIndex");

    @NotNull
    public ID<String, Collection<GspIncludeInfo>> getName() {
        ID<String, Collection<GspIncludeInfo>> iD = NAME;
        if (iD == null) {
            GspIncludeIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<GspIncludeInfo>, FileContent> getIndexer() {
        GspIncludeIndex gspIncludeIndex = this;
        if (gspIncludeIndex == null) {
            GspIncludeIndex.$$$reportNull$$$0(1);
        }
        return gspIncludeIndex;
    }

    public boolean acceptInput(@NotNull VirtualFile file) {
        if (file == null) {
            GspIncludeIndex.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            GspIncludeIndex.$$$reportNull$$$0(3);
        }
        fileTypeSink.consume((Object)GspFileType.GSP_FILE_TYPE);
        fileTypeSink.consume((Object)GroovyFileType.GROOVY_FILE_TYPE);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            GspIncludeIndex.$$$reportNull$$$0(4);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<GspIncludeInfo>> getValueExternalizer() {
        GspIncludeIndex gspIncludeIndex = this;
        if (gspIncludeIndex == null) {
            GspIncludeIndex.$$$reportNull$$$0(5);
        }
        return gspIncludeIndex;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        GspIncludeIndex gspIncludeIndex = this;
        if (gspIncludeIndex == null) {
            GspIncludeIndex.$$$reportNull$$$0(6);
        }
        return gspIncludeIndex;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 4;
    }

    @Nullable
    private static GspOuterGroovyElement extractGroovyOuterElement(XmlAttributeValue value) {
        PsiElement leftQuote = value.getFirstChild();
        if (!PsiImplUtil.isLeafElementOfType((PsiElement)leftQuote, (IElementType)GspTokenTypes.GSP_ATTR_VALUE_START_DELIMITER)) {
            return null;
        }
        PsiElement element = leftQuote.getNextSibling();
        if (element instanceof GspOuterGroovyElement) {
            if (!PsiImplUtil.isLeafElementOfType((PsiElement)element.getNextSibling(), (IElementType)GspTokenTypes.GSP_ATTR_VALUE_END_DELIMITER)) {
                return null;
            }
            return (GspOuterGroovyElement)element;
        }
        if (PsiImplUtil.isLeafElementOfType((PsiElement)element, (IElementType)GspTokenTypes.GEXPR_BEGIN)) {
            PsiElement groovyCodeElement = element.getNextSibling();
            if (!(groovyCodeElement instanceof GspOuterGroovyElement)) {
                return null;
            }
            PsiElement closeBracket = groovyCodeElement.getNextSibling();
            if (!PsiImplUtil.isLeafElementOfType((PsiElement)closeBracket, (IElementType)GspTokenTypes.GEXPR_END)) {
                return null;
            }
            PsiElement valueEndDelimiter = closeBracket.getNextSibling();
            if (PsiImplUtil.isLeafElementOfType((PsiElement)valueEndDelimiter, (IElementType)GspTokenTypes.GSP_ATTR_VALUE_END_DELIMITER)) {
                return (GspOuterGroovyElement)groovyCodeElement;
            }
        }
        return null;
    }

    @NotNull
    public Map<String, Collection<GspIncludeInfo>> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            GspIncludeIndex.$$$reportNull$$$0(7);
        }
        final HashMap<String, Collection<GspIncludeInfo>> res = new HashMap<String, Collection<GspIncludeInfo>>();
        PsiFile psiFile = inputData.getPsiFile();
        if (psiFile instanceof GspFile) {
            psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    if (!tag.getName().startsWith("tmpl:")) {
                        return;
                    }
                    ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode());
                    if (startTagName == null) {
                        return;
                    }
                    Object fileName = GspIncludeIndex.getFileNameByElementValue(startTagName.getText().substring("tmpl:".length()));
                    if (((String)fileName).isEmpty()) {
                        return;
                    }
                    fileName = "_" + (String)fileName;
                    XmlAttribute[] attributes = tag.getAttributes();
                    String[] attrNames = new String[attributes.length];
                    for (int i2 = 0; i2 < attributes.length; ++i2) {
                        attrNames[i2] = attributes[i2].getName();
                    }
                    GspIncludeIndex.add(res, (String)fileName, new GspIncludeInfo(startTagName.getStartOffset(), attrNames));
                }

                public void visitXmlAttribute(XmlAttribute modelAttribute) {
                    GrListOrMap map2;
                    if (!"model".equals(modelAttribute.getName())) {
                        return;
                    }
                    XmlTag tag = modelAttribute.getParent();
                    if (!tag.getName().startsWith("g:")) {
                        return;
                    }
                    boolean isTemplate = false;
                    XmlAttributeValue viewValue = GrailsPsiUtil.getAttributeValue(tag, "view");
                    if (viewValue == null) {
                        viewValue = GrailsPsiUtil.getAttributeValue(tag, "template");
                        isTemplate = true;
                    }
                    if (viewValue == null || !GrailsPsiUtil.isSimpleAttribute(viewValue)) {
                        return;
                    }
                    Object fileName = GspIncludeIndex.getFileNameByElementValue(viewValue.getValue());
                    if (((String)fileName).isEmpty()) {
                        return;
                    }
                    if (isTemplate) {
                        fileName = "_" + (String)fileName;
                    }
                    if ((map2 = GspIncludeIndex.extractMap(modelAttribute)) == null) {
                        return;
                    }
                    GspIncludeIndex.addModelMap(res, (String)fileName, (PsiElement)viewValue, map2);
                }
            });
            GspIncludeIndex.findModels(((GspFile)psiFile).getGroovyLanguageRoot(), res);
        } else if (psiFile instanceof GroovyFileBase) {
            GspIncludeIndex.findModels((GroovyFileBase)psiFile, res);
        }
        HashMap<String, Collection<GspIncludeInfo>> hashMap = res;
        if (hashMap == null) {
            GspIncludeIndex.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    private static void findModels(@NotNull GroovyFileBase file, @NotNull Map<String, Collection<GspIncludeInfo>> res) {
        if (file == null) {
            GspIncludeIndex.$$$reportNull$$$0(9);
        }
        if (res == null) {
            GspIncludeIndex.$$$reportNull$$$0(10);
        }
        String text = file.getText();
        new StringSearcher("model", true, true).processOccurrences((CharSequence)text, offset -> {
            PsiElement psi = file.findElementAt(offset);
            GrArgumentLabel label = (GrArgumentLabel)PsiTreeUtil.getParentOfType((PsiElement)psi, GrArgumentLabel.class);
            if (label != null) {
                GspIncludeIndex.processModelCandidate(label, res);
            }
            return true;
        });
    }

    private static void processModelCandidate(@NotNull GrArgumentLabel label, @NotNull Map<String, Collection<GspIncludeInfo>> res) {
        GrMethodCall methodCall;
        if (label == null) {
            GspIncludeIndex.$$$reportNull$$$0(11);
        }
        if (res == null) {
            GspIncludeIndex.$$$reportNull$$$0(12);
        }
        if (!"model".equals(label.getName())) {
            return;
        }
        PsiElement namedArgument = label.getParent();
        if (!(namedArgument instanceof GrNamedArgument)) {
            return;
        }
        GrExpression modelMap = ((GrNamedArgument)namedArgument).getExpression();
        if (!(modelMap instanceof GrListOrMap)) {
            return;
        }
        PsiElement eNamedArgumentOwner = namedArgument.getParent();
        if (!(eNamedArgumentOwner instanceof GrNamedArgumentsOwner)) {
            return;
        }
        GrNamedArgumentsOwner owner = (GrNamedArgumentsOwner)eNamedArgumentOwner;
        boolean isTemplate = false;
        GrNamedArgument view = owner.findNamedArgument("view");
        if (view == null) {
            view = owner.findNamedArgument("template");
            isTemplate = true;
        }
        if (view == null) {
            return;
        }
        GrExpression viewExpression = view.getExpression();
        if (!(viewExpression instanceof GrLiteralImpl)) {
            return;
        }
        Object value = ((GrLiteralImpl)viewExpression).getValue();
        if (!(value instanceof String)) {
            return;
        }
        Object fileName = GspIncludeIndex.getFileNameByElementValue((String)value);
        if (((String)fileName).isEmpty()) {
            return;
        }
        if (isTemplate) {
            fileName = "_" + (String)fileName;
        }
        if ((methodCall = PsiUtil.getMethodCallByNamedParameter((GrNamedArgument)((GrNamedArgument)namedArgument))) == null) {
            return;
        }
        GrExpression invokedExpression = methodCall.getInvokedExpression();
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            return;
        }
        GrExpression qualifier = ((GrReferenceExpression)invokedExpression).getQualifierExpression();
        if (qualifier != null && "g".equals(qualifier.getText())) {
            return;
        }
        GspIncludeIndex.addModelMap(res, (String)fileName, (PsiElement)viewExpression, (GrListOrMap)modelMap);
    }

    private static String getFileNameByElementValue(String value) {
        String path = StringUtil.trimEnd((String)value, (String)".gsp");
        path = path.substring(path.lastIndexOf(47) + 1);
        return path.trim();
    }

    @Nullable
    public static GrListOrMap extractMap(@NotNull XmlAttribute attribute) {
        XmlAttributeValue value;
        if (attribute == null) {
            GspIncludeIndex.$$$reportNull$$$0(13);
        }
        if ((value = attribute.getValueElement()) == null) {
            return null;
        }
        GspOuterGroovyElement outerGroovyElement = GspIncludeIndex.extractGroovyOuterElement(value);
        if (outerGroovyElement == null) {
            return null;
        }
        PsiElement groovyElement = attribute.getContainingFile().getViewProvider().findElementAt(outerGroovyElement.getTextOffset(), (Language)GroovyLanguage.INSTANCE);
        if (groovyElement == null) {
            return null;
        }
        groovyElement = groovyElement instanceof PsiWhiteSpace ? groovyElement.getNextSibling() : groovyElement.getParent();
        return groovyElement instanceof GrListOrMap ? (GrListOrMap)groovyElement : null;
    }

    private static void addModelMap(Map<String, Collection<GspIncludeInfo>> res, String fileName, PsiElement viewElement, @NotNull GrListOrMap modelMap) {
        GrNamedArgument[] namedArguments;
        if (modelMap == null) {
            GspIncludeIndex.$$$reportNull$$$0(14);
        }
        if ((namedArguments = modelMap.getNamedArguments()).length == 0) {
            return;
        }
        List<String> arguments = new ArrayList(namedArguments.length);
        for (GrNamedArgument namedArgument : namedArguments) {
            String labelName = GrailsPsiUtil.getPlainLabelName(namedArgument);
            if (labelName == null) continue;
            arguments.add(labelName);
        }
        if ((arguments = ContainerUtil.getFirstItems(arguments, (int)255)).isEmpty()) {
            return;
        }
        GspIncludeInfo includeInfo = new GspIncludeInfo(viewElement.getTextOffset(), ArrayUtil.toStringArray(arguments));
        GspIncludeIndex.add(res, fileName, includeInfo);
    }

    private static void add(Map<String, Collection<GspIncludeInfo>> res, String fileName, GspIncludeInfo includeInfo) {
        List list = (List)res.computeIfAbsent(fileName, __ -> new ArrayList());
        if (list.size() < 255) {
            list.add(includeInfo);
        }
    }

    public void save(@NotNull DataOutput out, Collection<GspIncludeInfo> value) throws IOException {
        if (out == null) {
            GspIncludeIndex.$$$reportNull$$$0(15);
        }
        assert (value.size() <= 255);
        out.writeByte(value.size());
        for (GspIncludeInfo aValue : value) {
            out.writeInt(aValue.getOffset());
            String[] argumentNames = aValue.getNamedArguments();
            assert (argumentNames.length <= 255);
            out.writeByte(argumentNames.length);
            for (String s2 : argumentNames) {
                out.writeUTF(s2);
            }
        }
    }

    public Collection<GspIncludeInfo> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            GspIncludeIndex.$$$reportNull$$$0(16);
        }
        int length = in.readUnsignedByte();
        ArrayList<GspIncludeInfo> res = new ArrayList<GspIncludeInfo>(length);
        for (int i2 = 0; i2 < length; ++i2) {
            int offset = in.readInt();
            int namedArgumentCount = in.readUnsignedByte();
            String[] namedArguments = new String[namedArgumentCount];
            for (int k = 0; k < namedArgumentCount; ++k) {
                namedArguments[k] = in.readUTF();
            }
            res.add(new GspIncludeInfo(offset, namedArguments));
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelMap";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/gspIndex/GspIncludeIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptInput";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findModels";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processModelCandidate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractMap";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addModelMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

