/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.formatter.JavascriptFormattingModelBuilder;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSDocCommentBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.addins.GrailsIntegrationUtil;
import org.jetbrains.plugins.grails.addins.js.CssIntegrationUtil;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.lang.gsp.formatter.ForeignLanguageBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspHtmlBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.processors.GspIndentProcessor;

public final class GspBlockGenerator {
    private GspBlockGenerator() {
    }

    public static void createGspBlockByTextRange(List<? super Block> result2, ASTNode child, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, TextRange textRange) {
        String s2;
        PsiElement parentPsi;
        ASTNode parent = child.getTreeParent();
        Indent indent = Indent.getNoneIndent();
        if (parent != null && (parentPsi = parent.getPsi()) instanceof XmlTag && policy.indentChildrenOf((XmlTag)parentPsi)) {
            indent = Indent.getNormalIndent();
        }
        if (!child.getTextRange().contains(textRange)) {
            return;
        }
        String text = child.getPsi().getContainingFile().getText();
        int start = textRange.getStartOffset();
        int end = textRange.getEndOffset();
        String string = s2 = end < text.length() - 1 ? text.substring(start, end) : text.substring(start);
        if (s2.trim().length() == 0) {
            return;
        }
        while (!text.substring(start, start + 1).equals(text.substring(start, start + 1).trim())) {
            ++start;
        }
        while (!text.substring(end - 1, end).equals(text.substring(end - 1, end).trim())) {
            --end;
        }
        assert (start < end);
        result2.add(new GspBlock(child, wrap, alignment, policy, indent, new TextRange(start, end)));
    }

    public static void createGspBlockByChildNode(List<? super Block> result2, ASTNode parentNode, ASTNode child, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy) {
        if (!GspBlockGenerator.canBeCorrectBlock(child)) {
            return;
        }
        result2.add(new GspBlock(child, wrap, alignment, policy, GspIndentProcessor.getGspChildIndent(parentNode, child, policy), child.getTextRange()));
    }

    public static void createHtmlBlockByChildNode(List<Block> result2, ASTNode parentNode, ASTNode child, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, XmlTag[] nestedGspTags) {
        if (!GspBlockGenerator.canBeCorrectBlock(child)) {
            return;
        }
        PsiElement childPsi = child.getPsi();
        if (GrailsIntegrationUtil.isJsSupportEnabled() && (JavaScriptIntegrationUtil.isJavaScriptInjection(childPsi) || JavaScriptIntegrationUtil.isJSEmbeddedContent(childPsi))) {
            GspBlockGenerator.createForeignLanguageBlock(JavaScriptSupportLoader.JAVASCRIPT.getLanguage(), child, result2, policy, policy.getSettings());
        } else if (GrailsIntegrationUtil.isCssSupportEnabled() && childPsi instanceof CssStylesheet) {
            GspBlockGenerator.createForeignLanguageBlock(childPsi.getLanguage(), child, result2, policy, policy.getSettings());
        } else {
            result2.add(new GspHtmlBlock(child, wrap, alignment, policy, GspIndentProcessor.getGspChildIndent(parentNode, child, policy), nestedGspTags));
        }
    }

    public static void createForeignLanguageBlock(Language childLanguage, ASTNode child, List<Block> result2, XmlFormattingPolicy policy, CodeStyleSettings settings) {
        PsiElement childPsi = child.getPsi();
        if (JavaScriptIntegrationUtil.isJavaScriptInjection(childPsi)) {
            GspBlockGenerator.generateBlockForJSInjection(childPsi, result2, settings);
        } else {
            FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext(childLanguage, childPsi);
            if (builder != null) {
                FormattingModel childModel = builder.createModel(FormattingContext.create((PsiElement)childPsi, (CodeStyleSettings)settings));
                Indent childIndent = GrailsIntegrationUtil.isCssSupportEnabled() && CssIntegrationUtil.isCssLanguage(childLanguage) ? Indent.getNoneIndent() : Indent.getNormalIndent();
                result2.add((Block)new ForeignLanguageBlock(child, policy, childModel.getRootBlock(), childIndent));
            }
        }
    }

    private static void generateBlockForJSInjection(PsiElement outer, List<Block> result2, CodeStyleSettings settings) {
        PsiFile file = outer.getContainingFile();
        int offset = outer.getTextRange().getStartOffset();
        PsiElement element = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)offset);
        FormattingModelBuilder builder = GspBlockGenerator.getJSFormattingModelBuilder(offset, file, outer);
        FormattingModel childModel = builder.createModel(FormattingContext.create((PsiElement)element, (CodeStyleSettings)settings));
        Block rootJsBlock = childModel.getRootBlock();
        result2.add(rootJsBlock);
    }

    private static FormattingModelBuilder getJSFormattingModelBuilder(final int offset, final PsiFile file, final PsiElement outer) {
        return new FormattingModelBuilder(){

            @NotNull
            public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
                if (formattingContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                CodeStyleSettings settings = formattingContext.getCodeStyleSettings();
                MyJSRootBlock jsBlock = new MyJSRootBlock(outer, settings, offset, file);
                FormattingModel formattingModel = JavascriptFormattingModelBuilder.createJSFormattingModel((PsiFile)file, (CodeStyleSettings)settings, (Block)jsBlock);
                if (formattingModel == null) {
                    1.$$$reportNull$$$0(1);
                }
                return formattingModel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "formattingContext";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createModel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createModel";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static boolean canBeCorrectBlock(ASTNode node) {
        return node != null && node.getText().trim().length() > 0;
    }

    private static final class MyJSRootBlock
    extends JSBlock {
        private List<Block> mySubBlocks;
        private final CodeStyleSettings mySettings;
        private final int myOffset;
        private final PsiFile myFile;

        private MyJSRootBlock(PsiElement outer, CodeStyleSettings settings, int offset, PsiFile file) {
            super(outer.getNode(), null, Indent.getNormalIndent(), null, settings);
            this.mySettings = settings;
            this.myOffset = offset;
            this.myFile = file;
            this.mySubBlocks = null;
        }

        @NotNull
        public List<Block> getSubBlocks() {
            if (this.mySubBlocks == null) {
                MyJSSubBlockVisitor visitor = new MyJSSubBlockVisitor(this.mySettings, this.myOffset);
                PsiFile jsFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)this.myFile, (int)this.myOffset);
                if (jsFile != null && jsFile.getNode() != null) {
                    visitor.visit((ASTNode)jsFile.getNode());
                }
                this.mySubBlocks = visitor.getBlocks();
            }
            List<Block> list = this.mySubBlocks;
            if (list == null) {
                MyJSRootBlock.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$MyJSRootBlock", "getSubBlocks"));
        }
    }

    private static class MyJSBlock
    extends JSBlock {
        private final int myOffset;
        private final CodeStyleSettings mySettings;

        MyJSBlock(ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, CodeStyleSettings settings, int offset) {
            super(child, childAlignment, childIndent, wrap, settings);
            this.myOffset = offset;
            this.mySettings = settings;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = super.getTextRange().shiftRight(this.myOffset);
            if (textRange == null) {
                MyJSBlock.$$$reportNull$$$0(0);
            }
            return textRange;
        }

        protected SubBlockVisitor createSubBlockVisitor() {
            return new MyJSSubBlockVisitor(this.mySettings, this.myOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$MyJSBlock", "getTextRange"));
        }
    }

    private static class MyJSSubBlockVisitor
    extends SubBlockVisitor {
        private final CodeStyleSettings mySettings;
        private final int myOffset;

        MyJSSubBlockVisitor(CodeStyleSettings settings, int offset) {
            super(null, null, JSBlockContext.createDefault((CodeStyleSettings)settings));
            this.mySettings = settings;
            this.myOffset = offset;
        }

        protected void addBlock(final Block block) {
            if (block instanceof JSDocCommentBlock) {
                super.addBlock(new Block(){

                    @NotNull
                    public TextRange getTextRange() {
                        TextRange textRange = block.getTextRange().shiftRight(myOffset);
                        if (textRange == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return textRange;
                    }

                    @NotNull
                    public List<Block> getSubBlocks() {
                        List list = block.getSubBlocks();
                        if (list == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return list;
                    }

                    public Wrap getWrap() {
                        return block.getWrap();
                    }

                    public Indent getIndent() {
                        return block.getIndent();
                    }

                    public Alignment getAlignment() {
                        return block.getAlignment();
                    }

                    public Spacing getSpacing(Block child1, @NotNull Block child2) {
                        if (child2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return block.getSpacing(child1, child2);
                    }

                    @NotNull
                    public ChildAttributes getChildAttributes(int newChildIndex) {
                        ChildAttributes childAttributes = block.getChildAttributes(newChildIndex);
                        if (childAttributes == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return childAttributes;
                    }

                    public boolean isIncomplete() {
                        return block.isIncomplete();
                    }

                    public boolean isLeaf() {
                        return block.isLeaf();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 2: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 2: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$MyJSSubBlockVisitor$1";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "child2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getTextRange";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getSubBlocks";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$MyJSSubBlockVisitor$1";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getChildAttributes";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "getSpacing";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 2: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
            } else {
                super.addBlock(block);
            }
        }

        public void visitElement(ASTNode node) {
            Wrap sharedWrap = JSFormatterUtil.createSharedWrapForChildren((ASTNode)node, (CommonCodeStyleSettings)this.mySettings.getCommonSettings((Language)JavascriptLanguage.INSTANCE), (JSCodeStyleSettings)this.myCustomSettings);
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child.getElementType() == JSTokenTypes.WHITE_SPACE || child.getTextRange().getLength() <= 0) continue;
                Wrap wrap = this.getWrap(node, child, sharedWrap);
                Indent childIndent = this.getIndent(node, child, null);
                MyJSBlock jsBlock = new MyJSBlock(child, null, childIndent, wrap, this.mySettings, this.myOffset);
                this.getBlocks().add(jsBlock);
            }
        }
    }
}

