/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.debug;

import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.debugger.GroovyCodeFragmentFactory;

public class GspCodeFragmentFactory
extends GroovyCodeFragmentFactory {
    private static PsiElement convertContext(PsiElement context) {
        PsiElement e;
        if (context == null) {
            return null;
        }
        if (context.getLanguage().equals(GroovyLanguage.INSTANCE)) {
            return context;
        }
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return context;
        }
        FileViewProvider viewProvider = file.getViewProvider();
        if (!(viewProvider instanceof GspFileViewProvider)) {
            return context;
        }
        for (e = viewProvider.findElementAt(context.getTextOffset(), (Language)GroovyLanguage.INSTANCE); e != null && !e.getLanguage().equals(GroovyLanguage.INSTANCE); e = e.getNextSibling()) {
        }
        return e == null ? context : e;
    }

    public JavaCodeFragment createCodeFragment(TextWithImports textWithImports, PsiElement context, Project project) {
        return super.createCodeFragment(textWithImports, GspCodeFragmentFactory.convertContext(context), project);
    }

    public JavaCodeFragment createPresentationCodeFragment(TextWithImports item, PsiElement context, Project project) {
        return super.createPresentationCodeFragment(item, GspCodeFragmentFactory.convertContext(context), project);
    }

    public boolean isContextAccepted(PsiElement context) {
        if (context == null) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        if (file == null || !(file.getViewProvider() instanceof GspFileViewProvider)) {
            return false;
        }
        return super.isContextAccepted(GspCodeFragmentFactory.convertContext(context)) && !super.isContextAccepted(context);
    }
}

