/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ReflectionUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.impl.GspGroovyFileImpl;
import org.jetbrains.plugins.grails.lang.gsp.psi.html.impl.GspHtmlFileImpl;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public class GspFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private static final Set<Language> LANGUAGES = new LinkedHashSet<Language>(Arrays.asList(new Language[]{GspLanguage.INSTANCE, GroovyLanguage.INSTANCE, HTMLLanguage.INSTANCE}));

    public GspFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        GspLanguage gspLanguage = GspLanguage.INSTANCE;
        if (gspLanguage == null) {
            GspFileViewProvider.$$$reportNull$$$0(0);
        }
        return gspLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = LANGUAGES;
        if (set == null) {
            GspFileViewProvider.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        HTMLLanguage hTMLLanguage = HTMLLanguage.INSTANCE;
        if (hTMLLanguage == null) {
            GspFileViewProvider.$$$reportNull$$$0(2);
        }
        return hTMLLanguage;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            GspFileViewProvider.$$$reportNull$$$0(3);
        }
        return new GspFileViewProvider((PsiManager)this.getManager(), copy, false);
    }

    protected PsiFile createFile(@NotNull Language language) {
        if (language == null) {
            GspFileViewProvider.$$$reportNull$$$0(4);
        }
        if (language == this.getBaseLanguage()) {
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
            assert (parserDefinition != null);
            return parserDefinition.createFile((FileViewProvider)this);
        }
        if (language == GroovyLanguage.INSTANCE) {
            return new GspGroovyFileImpl((FileViewProvider)this);
        }
        if (language == HTMLLanguage.INSTANCE) {
            return new GspHtmlFileImpl((FileViewProvider)this);
        }
        return super.createFile(language);
    }

    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            GspFileViewProvider.$$$reportNull$$$0(5);
        }
        PsiElement ret = null;
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement elementInBaseRoot = this.findElementByLanguage(offset, lang, ret, this.getBaseLanguage());
        if (GspFileViewProvider.isMeaningfulElement(elementInBaseRoot)) {
            return elementInBaseRoot;
        }
        for (Language language : LANGUAGES) {
            PsiElement found = this.findElementByLanguage(offset, lang, ret, language);
            if (ret != null && this.getPsi(language) == mainRoot) continue;
            ret = found;
        }
        return ret;
    }

    private PsiElement findElementByLanguage(int offset, Class<? extends Language> lang, PsiElement ret, Language language) {
        if (!ReflectionUtil.isAssignable(lang, language.getClass())) {
            return ret;
        }
        if (lang.equals(Language.class) && !LANGUAGES.contains(language)) {
            return ret;
        }
        PsiFile psiRoot = this.getPsi(language);
        PsiElement psiElement = GspFileViewProvider.findElementAt((PsiElement)psiRoot, (int)offset);
        if (psiElement == null || psiElement instanceof OuterLanguageElement && !GspFileViewProvider.isMeaningfulElement(psiElement)) {
            return ret;
        }
        if (ret == null) {
            ret = psiElement;
        }
        return ret;
    }

    private static boolean isMeaningfulElement(PsiElement elementInBaseRoot) {
        return JavaScriptIntegrationUtil.isJavaScriptInjection(elementInBaseRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/lang/gsp/GspFileViewProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/GspFileViewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

