/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.i18n;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeAction;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.i18n.GrailsI18nGroovyQuickFixHandler;
import org.jetbrains.plugins.grails.i18n.GrailsI18nQuickFixHandler;
import org.jetbrains.plugins.grails.i18n.GrailsI18nizeProvider;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspExpressionTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.html.impl.GspHtmlFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public class GspI18nIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = GrailsBundle.message("intention.text.extract.selected.text.to.message.properties", new Object[0]);
        if (string == null) {
            GspI18nIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            GspI18nIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static boolean isGroovyStringLiteral(Editor editor, PsiFile file) {
        if (file instanceof GspFile) {
            file = ((GspFile)file).getGroovyLanguageRoot();
        }
        return file instanceof GroovyFileBase && (file.getViewProvider() instanceof GspFileViewProvider || GrailsI18nizeProvider.isApplicableGroovyFile((GroovyFileBase)file)) && GrailsI18nGroovyQuickFixHandler.calculatePropertyValue(editor, file) != null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            GspI18nIntention.$$$reportNull$$$0(2);
        }
        if (GspI18nIntention.isGroovyStringLiteral(editor, file)) {
            return true;
        }
        if (!(file instanceof GspFile) && !(file instanceof GspHtmlFileImpl)) {
            return false;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return false;
        }
        TextRange selectedRange = JavaI18nUtil.getSelectedRange((Editor)editor, (PsiFile)file);
        if (selectedRange == null) {
            return false;
        }
        PsiElement e = file.getViewProvider().findElementAt(selectedRange.getStartOffset(), (Language)HTMLLanguage.INSTANCE);
        while (true) {
            if (e == null) {
                return false;
            }
            if (e instanceof OuterLanguageElement) {
                PsiElement gspElement = file.getViewProvider().findElementAt(e.getTextOffset(), (Language)GspLanguage.INSTANCE);
                if (gspElement == null) {
                    return false;
                }
                PsiElement exprTag = gspElement.getParent();
                if (!(exprTag instanceof GspExpressionTag)) {
                    return false;
                }
                TextRange exprTagTextRange = exprTag.getTextRange();
                if (!selectedRange.contains(exprTagTextRange)) {
                    return false;
                }
                if (selectedRange.getEndOffset() == exprTagTextRange.getEndOffset()) break;
                e = file.getViewProvider().findElementAt(exprTagTextRange.getEndOffset(), (Language)HTMLLanguage.INSTANCE);
                continue;
            }
            if (e.getTextOffset() + e.getTextLength() >= selectedRange.getEndOffset()) break;
            e = PsiTreeUtil.nextLeaf((PsiElement)e);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            GspI18nIntention.$$$reportNull$$$0(3);
        }
        if (GspI18nIntention.isGroovyStringLiteral(editor, file)) {
            I18nizeAction.doI18nSelectedString((Project)project, (Editor)editor, (PsiFile)file, (I18nQuickFixHandler)GrailsI18nGroovyQuickFixHandler.INSTANCE);
            return;
        }
        if (file instanceof GspFile) {
            file = file.getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE);
        }
        assert (file instanceof GspHtmlFileImpl);
        PsiFile gspFile = file.getViewProvider().getPsi((Language)GspLanguage.INSTANCE);
        assert (gspFile != null);
        I18nizeAction.doI18nSelectedString((Project)project, (Editor)editor, (PsiFile)gspFile, (I18nQuickFixHandler)GrailsI18nQuickFixHandler.INSTANCE);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/i18n/GspI18nIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/i18n/GspI18nIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

